#ifndef I2C_ALGO_USB_H
#define I2C_ALGO_USB_H 1

#include <linux/i2c.h>

struct i2c_algo_usb_data {
       void *data;		/* private data for lowlevel routines */
//	int (*init_addr) (void *data, unsigned char addr);
       int (*inb) (void *data, unsigned char addr, char *buf, short len);
       int (*outb) (void *data, unsigned char addr, char *buf, short len);

       /* local settings */
       int udelay;
       int mdelay;
       int timeout;
};

#define I2C_USB_ADAP_MAX	16

int i2c_usb_add_bus(struct i2c_adapter *);
int i2c_usb_del_bus(struct i2c_adapter *);

#endif
