/*
 *  evtest.c  Version 0.1
 *
 *  Copyright (c) 1999 Vojtech Pavlik
 *
 *  Event device test program
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * Should you need to contact me, the author, you can do so either by
 * e-mail - mail your message to <vojtech@ucw.cz>, or by paper mail:
 * Vojtech Pavlik, Ucitelska 1576, Prague 8, 182 00 Czech Republic
 */

#include <asm/types.h>
#include <linux/input.h>

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

char *events[EV_MAX + 1] = { 
/* x00 */ "Reset", "Key", "Relative", "Absolute", 
/* x04 */ NULL, NULL, NULL, NULL,
/* x08 */ NULL, NULL, NULL, NULL,
/* x0c */ NULL, NULL, NULL, NULL,
/* x10 */ NULL, "LED", "Sound", "Repeat",
/* x14 */ NULL, NULL, NULL, NULL,
/* x18 */ NULL, NULL, NULL, NULL,
/* x1c */ NULL, NULL, NULL, "MAX", };
char *keys[KEY_MAX + 1] = { "Reserved", "Esc", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "Minus", "Equal", "Backspace",
/* 15 */ "Tab", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "LeftBrace", "RightBrace", "Enter", "LeftControl", "A", "S", "D", "F", "G",
/* 35 */ "H", "J", "K", "L", "Semicolon", "Apostrophe", "Grave", "LeftShift", "BackSlash", "Z", "X", "C", "V", "B", "N", "M", "Comma", "Dot",
/* 53 */ "Slash", "RightShift", "KPAsterisk", "LeftAlt", "Space", "CapsLock", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10",
/* 69 */ "NumLock", "ScrollLock", "KP7", "KP8", "KP9", "KPMinus", "KP4", "KP5", "KP6", "KPPlus", "KP1", "KP2", "KP3", "KP0", "KPDot", "103rd",
/* 85 */ "F13", "102nd", "F11", "F12", "F14", "F15", "F16", "F17", "F18", "F19", "F20", "KPEnter", "RightCtrl", "KPSlash", "SysRq",
/* 100 */ "RightAlt", "LineFeed", "Home", "Up", "PageUp", "Left", "Right", "End", "Down", "PageDown", "Insert", "Delete", "Macro", "Mute",
/* 114 */ "VolumeDown", "VolumeUp", "Power", "KPEqual", "KPPlusMinus", "Pause", "F21", "F22", "F23", "F24", "JPN", "LeftMeta", "RightMeta",
/* 127 */ "Compose",
/* 128 */ "Stop", "Again", "Props", "Undo", "Front", "Copy", "Open", "Paste", "Find", "Cut", "Help", "Menu", "Calc", "Setup",
/* 142 */ "Sleep", "WakeUp", "File", "SendFile", "DeleteFile", "X-fer", "Prog1", "Prog2", "WWW", "MSDOS", "Coffee", "Direction",
/* 154 */ "CycleWindows", "Mail", "Bookmarks", "Computer", "Back", "Forward", "CloseCD", "EjectCD", "EjectCloseCD", "NextSong", "PlayPause",
/* 165 */ "PreviousSong", "StopCD", "Record", "Rewind", "Phone", "ISOKey", "Config", "HomePage", "Refresh", "Exit", "Move", "Edit", "ScrollUp",
/* 178 */ "ScrollDown", NULL, "UNKNOWN",
/* 181 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 190 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 200 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 210 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 220 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 230 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 240 */ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
/* 250 */ NULL, NULL, NULL, NULL, NULL, NULL,
/* x100 */ "Btn0", "Btn1", "Btn2", "Btn3",
    "Btn4", "Btn5", "Btn6", "Btn7",
    "Btn8", "Btn9", NULL, NULL,
    NULL, NULL, NULL, NULL,
/* x110 */ "LeftBtn", "RightBtn", "MiddleBtn", "SideBtn",
    "ExtraBtn", "ForwardBtn", "BackBtn", NULL,
    NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL,
/* x120 */ "Trigger", "ThumbBtn", "ThumbBtn2", "TopBtn",
    "TopBtn2", "PinkieBtn", "BaseBtn", "BaseBtn2",
    "BaseBtn3", "BaseBtn4", "BaseBtn5", "BaseBtn6",
    NULL, NULL, NULL, NULL,
/* x130 */ "BtnA", "BtnB", "BtnC", "BtnX",
    "BtnY", "BtnZ", "BtnTL", "BtnTR",
    "BtnTL2", "BtnTR2", "BtnSelect", "BtnStart",
    "BtnMode", NULL, NULL, NULL,
/* x140 */ "ToolPen", "ToolRubber", "ToolBrush", "ToolPencil",
    "ToolAirbrush", "ToolFinger", "ToolMouse", "ToolLens",
    NULL, NULL, "Touch", "Stylus",
    "Stylus2" };

char *relatives[REL_MAX + 1] = { "X", "Y", "Z", NULL, NULL, NULL, "HWheel", "Dial", "Wheel" };
char *absolutes[ABS_MAX + 1] = { "X", "Y", "Z", "Rx", "Ry", "Rz", "Throttle", "Rudder", NULL, NULL, NULL, NULL, NULL, NULL, NULL,
NULL, "Hat0X", "Hat0Y", "Hat1X", "Hat1Y", "Hat2X", "Hat2Y", "Hat3X", "Hat 3Y", "Pressure", "Distance", "XTilt", "YTilt"};
char *leds[LED_MAX + 1] = { "NumLock", "CapsLock", "ScrollLock", "Compose", "Kana" };
char *repeats[REP_MAX + 1] = { "Delay", "Period" };
char *sounds[SND_MAX + 1] = { "Bell", "Click" };

char **names[EV_MAX + 1] = { events, keys, relatives, absolutes, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
NULL, NULL, leds, sounds, repeats };

int main (int argc, char **argv)
{
    int fd, rd, i;
    struct input_event ev[64];

    if (argc < 2) {
	printf ("Usage: evtest /dev/inputX\n");
	printf ("Where X = input device number\n");
	exit (1);
    }

#if 0
    for (i = 0; i < KEY_MAX; i++)
	printf("%d - %s\n", i, keys[i]);
#endif

    if ((fd = open(argv[argc - 1], O_RDONLY)) < 0) {
	perror("evtest");
	exit(1);
    }

    printf("Testing ... (interrupt to exit)\n");

    while (1) {
	rd = read(fd, ev, sizeof(struct input_event) * 64);

	if (rd < sizeof(struct input_event)) {
	    perror("\nevtest: error reading");
	    exit (1);
	}

	for (i = 0; i < rd / sizeof(struct input_event); i++) {
#if 1 /* MotionEvents ausblenden */
	    if (ev[i].type == 3) continue;
#endif	   
	    printf ("Event: time %ld.%06ld, type %d (%s), code %d (%s), "
		    "value %d\n",
		    ev[i].time.tv_sec, ev[i].time.tv_usec, ev[i].type,
		    events[ev[i].type] ? events[ev[i].type] : "?",
		    ev[i].code,
		    names[ev[i].type] ? (names[ev[i].type][ev[i].code] ?
			names[ev[i].type][ev[i].code] : "?") : "?",
		    ev[i].value);
	}
    }
}
