/* $XConsortium: xf86Wacom.c /main/20 1996/10/27 11:05:20 kaleb $ */
/*
 * Copyright 1995-1997 by Frederic Lepied, France. <Fredric.Lepied@sugix.frmug.org>
 *                                                                            
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is  hereby granted without fee, provided that
 * the  above copyright   notice appear  in   all  copies and  that both  that
 * copyright  notice   and   this  permission   notice  appear  in  supporting
 * documentation, and that   the  name of  Frederic   Lepied not  be  used  in
 * advertising or publicity pertaining to distribution of the software without
 * specific,  written      prior  permission.     Frederic  Lepied   makes  no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.                   
 *                                                                            
 * FREDERIC  LEPIED DISCLAIMS ALL   WARRANTIES WITH REGARD  TO  THIS SOFTWARE,
 * INCLUDING ALL IMPLIED   WARRANTIES OF MERCHANTABILITY  AND   FITNESS, IN NO
 * EVENT  SHALL FREDERIC  LEPIED BE   LIABLE   FOR ANY  SPECIAL, INDIRECT   OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA  OR PROFITS, WHETHER  IN  AN ACTION OF  CONTRACT,  NEGLIGENCE OR OTHER
 * TORTIOUS  ACTION, ARISING    OUT OF OR   IN  CONNECTION  WITH THE USE    OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

/* $XFree86: xc/programs/Xserver/hw/xfree86/common/xf86Wacom.c,v 3.25.2.5 1998/02/07 10:05:21 hohndel Exp $ */

/*
 Modified for Linux USB by MATSUMURA Namihiko, Japan.
 <po-jp@geocities.co.jp>
 
 Additional changes by Brion Vibber <brion@pobox.com>, 5/00
 
 random bits - my range seems to be 0-20412 X, 0-14844 Y, 0-511 Z
 currently I have gsumi pretty much working for a single stylus device,
 although it drags thin lines out when not touching, and seems to be confused
 by out-of-proximity issues.
 
 Eraser seems to have "issues". Its events are being reported as belonging to
 the cursor!  Cursor is not a priority for me.
 
 I lost most of my updated source due to a &%(*# crash. Friggin dev kernels...

-Aaron Optimizer Digulla <digulla@hepe.com> Thu May 18 21:52:00 MEST 2000

 Disabled most code that did not work; most things work pretty well now.
 Known issues:

 - A lot of "Pen left/touched the table" events are generated. They
 are in the input stream (evtest shows them), so there is nothing I can do here
 in this driver. That must be fixed in the usbdriver or, if that's a bug in
 the hardware, it must be fixed by checking the pressure. Sometimes,
 there is no "touch" event, if the pen touches the tablet for the first
 time or no left event, when he leaves.

 A good way to test this is to move the stylus over the table without
 moving the hand (ie. just twisting it).

 Also, when the driver thinks the stylus has not yet left the tablet
 and I bring it back, the cursor positions jumps with the old pressure
 to a new position (so if you're in GIMP, something will be drawn to
 the screen).

 - Sometimes, illegal ButtonUp/Down events are generated (these contain
 more then one button that changed). Or is that ok ?

 - Things that work: Pressure works now, movement is ok (except
 when the contact-code breaks).

-Aaron Optimizer Digulla <digulla@hepe.com> Thu May 19 2000

 Cleaned the code. Thrown most old junk overboard. Code is mostly
 clean, now, and can proudly present a couple of comments in the
 important parts :-)

 Fixes:
    - ButtonPress/Release events are now always correct
    - X is now correctly notified when the cursor/stylus comes
      near the tablet and when it leaves. All buttons will be
      released when the cursor/stylus leaves the tablet to avoid
      to inadvertly stroke to the position where it enters the
      tablet again.
 */

#define NeedVarargsPrototypes 1
#include "Xos.h"
#include <signal.h>

#define NEED_EVENTS
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "inputstr.h"
#include "scrnintstr.h"
#include "XI.h"
#include "XIproto.h"
#include "keysym.h"

#if defined(sun) && !defined(i386)
#define POSIX_TTY
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <stdio.h>

#include "extio.h"
#else
#include "compiler.h"

#include "xf86.h"
#include "xf86Procs.h"
#include "xf86_OSlib.h"
#include "xf86_Config.h"
#include "xf86Xinput.h"
#include "xf86Version.h"
#endif

#if !defined(sun) || defined(i386)
#include "osdep.h"
#include "exevents.h"

#include "extnsionst.h"
#include "extinit.h"
#endif

#include <asm/types.h>
#include "linux/input.h"

/******************************************************************************
 * debugging macro
 *****************************************************************************/
 /* FIXME Should not do this to allow to specify DEBUG from the command
  * line */
#ifdef DBG
#undef DBG
#endif
#ifdef DEBUG
#undef DEBUG
#endif

/* Yes we're on the way of debugging! */
/* static int      debug_level = 0;*/
#ifndef INI_DEBUG_LEVEL
#define INI_DEBUG_LEVEL 0
#endif
static int      debug_level = INI_DEBUG_LEVEL;
#define DEBUG 1
#if DEBUG
#define DBG(lvl, f) {if ((lvl) <= debug_level) f;}
#else
#define DBG(lvl, f)
#endif

/******************************************************************************
 * WacomDeviceRec flags
 *****************************************************************************/
#define DEVICE_ID(flags) ((flags) & 0x07)

#define STYLUS_ID		1
#define CURSOR_ID		2
#define ERASER_ID		4
#define ABSOLUTE_FLAG		8
#define FIRST_TOUCH_FLAG	16
#define	KEEP_SHAPE_FLAG		32

/******************************************************************************
 * WacomCommonRec flags
 *****************************************************************************/
#define TILT_FLAG	1

typedef struct
{
    /* configuration fields */
    unsigned char	flags;		/* various flags (device type, absolute, first touch...) */
    int			topX;		/* X top */
    int			topY;		/* Y top */
    int			bottomX;	/* X bottom */
    int			bottomY;	/* Y bottom */
    double		factorX;	/* X factor */
    double		factorY;	/* Y factor */

    struct _WacomCommonRec *common;	/* common info pointer */
    
    /* state fields */
    int			oldX;		/* previous X position */
    int			oldY;		/* previous Y position */
    int			oldZ;		/* previous pressure */
    int			oldTiltX;	/* previous tilt in x direction */
    int			oldTiltY;	/* previous tilt in y direction */    
    int			oldButtons;	/* previous buttons state */
    int			oldProximity;	/* previous proximity */

  /*
    int newX, newY, newZ, newButtons, newProximity;
    int newIsStylus, newIsButton;
  */
} WacomDeviceRec, *WacomDevicePtr;

typedef struct _WacomCommonRec 
{
    char	       *wcmDevice;	/* device file name */
    int                 wcmDeviceType;  /* STYLUS/CURSOR/ERASE_ID */
    int			wcmSuppress;	/* transmit position if increment is superior */
    unsigned char	wcmFlags;	/* various flags (handle tilt) */
    int			wcmMaxX;	/* max X value */
    int			wcmMaxY;	/* max Y value */
    int			wcmMaxZ;	/* max Z value */
    int			wcmResolX;	/* X resolution in points/inch */
    int			wcmResolY;	/* Y resolution in points/inch */
    int			wcmResolZ;	/* Z resolution in points/inch */
    LocalDevicePtr     *wcmDevices;	/* array of all devices sharing the same port */
    int			wcmNumDevices;	/* number of devices */
    int			wcmIndex;	/* number of bytes read */
    int			wcmPktLength;	/* length of a packet */
    unsigned char	wcmData[9];	/* data read on the device */
    Bool		wcmHasEraser;	/* True if an eraser has been configured */
} WacomCommonRec, *WacomCommonPtr;

/******************************************************************************
 * configuration stuff
 *****************************************************************************/
#define CURSOR_SECTION_NAME "wacomcursor"
#define STYLUS_SECTION_NAME "wacomstylus"
#define ERASER_SECTION_NAME "wacomeraser"
#define PORT		1
#define DEVICENAME	2
#define THE_MODE	3
#define SUPPRESS	4
#define DEBUG_LEVEL     5
#define TILT_MODE	6
#define HISTORY_SIZE	7
#define ALWAYS_CORE	8
#define	KEEP_SHAPE	9
#define	TOP_X		10
#define	TOP_Y		11
#define	BOTTOM_X	12
#define	BOTTOM_Y	13

#if !defined(sun) || defined(i386)
static SymTabRec WcmTab[] = {
  { ENDSUBSECTION,	"endsubsection" },
  { PORT,		"port" },
  { DEVICENAME,		"devicename" },
  { THE_MODE,		"mode" },
  { SUPPRESS,		"suppress" },
  { DEBUG_LEVEL,	"debuglevel" },
  { TILT_MODE,		"tiltmode" },
  { HISTORY_SIZE,	"historysize" },
  { ALWAYS_CORE,	"alwayscore" },
  { KEEP_SHAPE,		"keepshape" },
  { TOP_X,		"topx" },
  { TOP_Y,		"topy" },
  { BOTTOM_X,		"bottomx" },
  { BOTTOM_Y,		"bottomy" },
  { -1,			"" }
};

#define RELATIVE	1
#define ABSOLUTE	2

static SymTabRec ModeTabRec[] = {
  /*  { RELATIVE,	"relative" },*/
  { ABSOLUTE,	"absolute" },
  { -1,		"" }
};
  
#endif

/******************************************************************************
 * constant and macros declarations
 *****************************************************************************/
#define BUFFER_SIZE 256		/* size of reception buffer */
#define XI_STYLUS "STYLUS"	/* X device name for the stylus */
#define XI_CURSOR "CURSOR"	/* X device name for the cursor */
#define XI_ERASER "ERASER"	/* X device name for the eraser */
#define MAX_VALUE 100           /* number of positions */
#define MAXTRY 2                /* max number of try to receive magic number */
#define SYSCALL(call) while(((call) == -1) && (errno == EINTR))

#define COMMAND_SET_MASK	0xc0
#define BAUD_RATE_MASK		0x0a
#define PARITY_MASK		0x30
#define DATA_LENGTH_MASK	0x40
#define STOP_BIT_MASK		0x80

#define HEADER_BIT	0x80
#define ZAXIS_SIGN_BIT	0x40
#define ZAXIS_BIT    	0x04
#define ZAXIS_BITS    	0x7f
#define POINTER_BIT     0x20
#define PROXIMITY_BIT   0x40
#define BUTTON_FLAG	0x08
#define BUTTONS_BITS	0x78
#define TILT_SIGN_BIT	0x40
#define TILT_BITS	0x7f

/* defines to discriminate second side button and the eraser */
#define ERASER_PROX	4
#define OTHER_PROX	1

#define HANDLE_TILT(comm) ((comm)->wcmPktLength == 9)
/* Strange GCC syntax: Evaluate 'v' only once */
#define ABS(v)	    ({ int _v = (v); _v < 0 ? -_v : _v; })

#define mils(res) (res * 1000 / 2.54) /* resolution */

/******************************************************************************
 * Function/Macro keys variables
 *****************************************************************************/
static KeySym wacom_map[] = 
{
    NoSymbol,	/* 0x00 */
    NoSymbol,	/* 0x01 */
    NoSymbol,	/* 0x02 */
    NoSymbol,	/* 0x03 */
    NoSymbol,	/* 0x04 */
    NoSymbol,	/* 0x05 */
    NoSymbol,	/* 0x06 */
    NoSymbol,	/* 0x07 */
    XK_F1,	/* 0x08 */
    XK_F2,	/* 0x09 */
    XK_F3,	/* 0x0a */
    XK_F4,	/* 0x0b */
    XK_F5,	/* 0x0c */
    XK_F6,	/* 0x0d */
    XK_F7,	/* 0x0e */
    XK_F8,	/* 0x0f */
    XK_F8,	/* 0x10 */
    XK_F10,	/* 0x11 */
    XK_F11,	/* 0x12 */
    XK_F12,	/* 0x13 */
    XK_F13,	/* 0x14 */
    XK_F14,	/* 0x15 */
    XK_F15,	/* 0x16 */
    XK_F16,	/* 0x17 */
    XK_F17,	/* 0x18 */
    XK_F18,	/* 0x19 */
    XK_F19,	/* 0x1a */
    XK_F20,	/* 0x1b */
    XK_F21,	/* 0x1c */
    XK_F22,	/* 0x1d */
    XK_F23,	/* 0x1e */
    XK_F24,	/* 0x1f */
    XK_F25,	/* 0x20 */
    XK_F26,	/* 0x21 */
    XK_F27,	/* 0x22 */
    XK_F28,	/* 0x23 */
    XK_F29,	/* 0x24 */
    XK_F30,	/* 0x25 */
    XK_F31,	/* 0x26 */
    XK_F32	/* 0x27 */
};

/* minKeyCode = 8 because this is the min legal key code */
static KeySymsRec wacom_keysyms = {
  /* map	minKeyCode	maxKC	width */
  wacom_map,	8,		0x27,	1
};

/******************************************************************************
 * external declarations
 *****************************************************************************/
#if defined(sun) && !defined(i386)
#define ENQUEUE suneqEnqueue
#else
#define ENQUEUE xf86eqEnqueue

extern void xf86eqEnqueue(
#if NeedFunctionPrototypes
    xEventPtr /*e*/
#endif
);
#endif

extern void miPointerDeltaCursor(
#if NeedFunctionPrototypes
    int /*dx*/,
    int /*dy*/,
    unsigned long /*time*/
#endif
);

#if NeedFunctionPrototypes
static LocalDevicePtr xf86WcmAllocateStylus(void);
static LocalDevicePtr xf86WcmAllocateCursor(void);
static LocalDevicePtr xf86WcmAllocateEraser(void);
#endif

#if !defined(sun) || defined(i386)
/*
 ***************************************************************************
 *
 * xf86WcmConfig --
 *	Configure the device.
 *
 ***************************************************************************
 */
/* Unlike what the name might suggest, this function only configures
   variables in the driver and doesn't send commands to device. */
static Bool
xf86WcmConfig(LocalDevicePtr    *array,
              int               inx,
              int               max,
	      LexPtr            val)
{
    LocalDevicePtr      dev = array[inx];
    WacomDevicePtr	priv = (WacomDevicePtr)(dev->private);
    WacomCommonPtr	common = priv->common;
    int			token;
    int			mtoken;
    
    DBG(1, ErrorF("xf86WcmConfig\n"));
    
    while ((token = xf86GetToken(WcmTab)) != ENDSUBSECTION)
    {
	switch(token)
	{
	case DEVICENAME:
	    if (xf86GetToken(NULL) != STRING)
		xf86ConfigError("Option string expected");
	    
	    dev->name = strdup(val->str);
	    
	    if (xf86Verbose)
		ErrorF("%s Wacom X device name is %s\n", XCONFIG_GIVEN,
		       dev->name);
	    break;
	    
	case PORT:
	    if (xf86GetToken(NULL) != STRING)
		xf86ConfigError("Option string expected");
	    else
	    {
		int     loop;
		
		/* try to find another wacom device which share the same port */
		for(loop=0; loop<max; loop++)
		{
		    if (loop == inx)
			continue;
		    
		    if ((array[loop]->device_config == xf86WcmConfig) &&
			(strcmp(((WacomDevicePtr)array[loop]->private)->common->wcmDevice, val->str) == 0)) {
			DBG(2, ErrorF("xf86WcmConfig wacom port share between"
				      " %s and %s\n",
				      dev->name, array[loop]->name));
			
			((WacomDevicePtr) array[loop]->private)->common->wcmHasEraser |= common->wcmHasEraser;
			xfree(common->wcmDevices);
			xfree(common);
			common = priv->common = ((WacomDevicePtr) array[loop]->private)->common;
			common->wcmNumDevices++;
			common->wcmDevices = (LocalDevicePtr *) xrealloc(common->wcmDevices,
									 sizeof(LocalDevicePtr) * common->wcmNumDevices);
			common->wcmDevices[common->wcmNumDevices - 1] = dev;
			break;
		    }
		}
		
		if (loop == max)
		{
		    common->wcmDevice = strdup(val->str);
		    if (xf86Verbose)
			ErrorF("%s Wacom port is %s\n", XCONFIG_GIVEN,
			       common->wcmDevice);
		}
	    }
	    break;
	    
	case THE_MODE:
	    mtoken = xf86GetToken(ModeTabRec);
	    if ((mtoken == EOF) || (mtoken == STRING) || (mtoken == NUMBER)) 
		xf86ConfigError("Mode type token expected");
	    else
	    {
		switch (mtoken)
		{
		case ABSOLUTE:
		    priv->flags = priv->flags | ABSOLUTE_FLAG;
		    break;
		case RELATIVE:
		    priv->flags = priv->flags & ~ABSOLUTE_FLAG; 
		    break;
		default:
		    xf86ConfigError("Illegal Mode type");
		    break;
		}
	    }
	    break;
	    
	case SUPPRESS:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    common->wcmSuppress = val->num;
	    if (xf86Verbose)
		ErrorF("%s Wacom suppress value is %d\n", XCONFIG_GIVEN,
		       common->wcmSuppress);      
	    break;
	    
	case DEBUG_LEVEL:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    debug_level = val->num;
	    if (xf86Verbose)
	    {
#if DEBUG
		ErrorF("%s Wacom debug level sets to %d\n", XCONFIG_GIVEN,
		       debug_level);      
#else
		ErrorF("%s Wacom debug level not sets to %d because"
		       " debugging is not compiled\n", XCONFIG_GIVEN,
		       debug_level);      
#endif
	    }
	    break;

	case TILT_MODE:
	    common->wcmFlags |= TILT_FLAG;
	    break;
	    
	case HISTORY_SIZE:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    dev->history_size = val->num;
	    if (xf86Verbose)
		ErrorF("%s Wacom Motion history size is %d\n", XCONFIG_GIVEN,
		       dev->history_size);      
	    break;

	case ALWAYS_CORE:
	    xf86AlwaysCore(dev, TRUE);
	    if (xf86Verbose)
		ErrorF("%s Wacom device always stays core pointer\n",
		       XCONFIG_GIVEN);
	    break;

	case KEEP_SHAPE:
	    priv->flags |= KEEP_SHAPE_FLAG;
	    if (xf86Verbose)
		ErrorF("%s Wacom keeps shape\n",
		       XCONFIG_GIVEN);
	    break;

	case TOP_X:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    priv->topX = val->num;
	    if (xf86Verbose)
		ErrorF("%s Wacom top x = %d\n", XCONFIG_GIVEN, priv->topX);
	    break;

	case TOP_Y:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    priv->topY = val->num;
	    if (xf86Verbose)
		ErrorF("%s Wacom top y = %d\n", XCONFIG_GIVEN, priv->topY);
	    break;

	case BOTTOM_X:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    priv->bottomX = val->num;
	    if (xf86Verbose)
		ErrorF("%s Wacom bottom x = %d\n", XCONFIG_GIVEN, priv->bottomX);
	    break;

	case BOTTOM_Y:
	    if (xf86GetToken(NULL) != NUMBER)
		xf86ConfigError("Option number expected");
	    priv->bottomY = val->num;
	    if (xf86Verbose)
		ErrorF("%s Wacom bottom y = %d\n", XCONFIG_GIVEN, priv->bottomY);
	    break;

	case EOF:
	    FatalError("Unexpected EOF (missing EndSubSection)");
	    break;
	    
	default:
	    xf86ConfigError("Wacom subsection keyword expected");
	    break;
	}
    }
    
    DBG(1, ErrorF("xf86WcmConfig name=%s\n", common->wcmDevice));
    
    return Success;
}
#endif /* !defined(sun) || defined(i386) */

/*
 ***************************************************************************
 *
 * xf86WcmSendEvents --
 *
 ***************************************************************************
 */
static void
xf86WcmSendEvents(LocalDevicePtr	local,
		  int			device,
		  int			is_proximity,
		  int			x,
		  int			y,
		  int			z,
		  int			buttons)
{
    WacomDevicePtr	priv = (WacomDevicePtr) local->private;
    WacomCommonPtr	common = priv->common;
    int			tx = 0, ty = 0;
    int			rx, ry, rz, rtx, rty;
    int			is_core_pointer, is_absolute;

    DBG(16, ErrorF("xf86WacomSendEvents PASS 1 [%s] prox=%s x=%5d y=%5d z=%4d buttons=%d\n",
		  device == STYLUS_ID ? "stylus" : (
			device == ERASER_ID ? "eraser" : "cursor"),
		  is_proximity ? "T" : "F",
		  x, y, z,
		  buttons));

    /* Translate coordinates according to Top and Bottom points
     * if we are outside the zone do as a ProximityOut event.
     */

    x = x - priv->topX;
    y = y - priv->topY;

    if (x > priv->bottomX)
    {
	x = priv->bottomX;
	buttons = 0; /* Do not render along the side of the input area */
    }
    else if (x < 0)
    {
	x = 0;
	buttons = 0; /* Do not render along the side of the input area */
    }
	    
    if (y > priv->bottomY)
    {
	y = priv->bottomY;
	buttons = 0; /* Do not render along the side of the input area */
    }
    else if (y < 0)
    {
	y = 0;
	buttons = 0; /* Do not render along the side of the input area */
    }
    
    if (device != CURSOR_ID)
    {
	/* handle tilt values only for stylus */
	if (HANDLE_TILT(common))
	{
	    tx = (common->wcmData[7] & TILT_BITS);
	    ty = (common->wcmData[8] & TILT_BITS);
	    if (common->wcmData[7] & TILT_SIGN_BIT)
		tx = - (~(tx-1) & 0x7f);
	    if (common->wcmData[8] & TILT_SIGN_BIT)
		ty = - (~(ty-1) & 0x7f);
	}
    }

    DBG(16, ErrorF("xf86WacomSendEvents PASS 2 [%s] prox=%s x=%5d y=%5d z=%4d buttons=%d\n",
		  device == STYLUS_ID ? "stylus" : (
			device == ERASER_ID ? "eraser" : "cursor"),
		  is_proximity ? "T" : "F",
		  x, y, z,
		  buttons));

    is_absolute = (priv->flags & ABSOLUTE_FLAG) != 0;
    is_core_pointer = xf86IsCorePointer(local->dev);

    if (is_core_pointer)
    {
	x = x * priv->factorX;
	y = y * priv->factorY;
    }

    /* sets rx and ry according to the mode */
    if (is_absolute)
    {
	rx = x;
	ry = y;
	rz = z;
	rtx = tx;
	rty = ty;
    }
    else
    {
	rx = x - priv->oldX;
	ry = y - priv->oldY;
	rz = z - priv->oldZ;  
	rtx = tx - priv->oldTiltX;
	rty = ty - priv->oldTiltY;
    }

    /* First, tell X that we're back if necessary */
    if (is_proximity && !priv->oldProximity)
    {
	if (!is_core_pointer)
	{
	    DBG (5, ErrorF("xf86WacomSendEvents S0 PostProximEvent     1 0 5 %5d %5d %4d %d %d\n", rx, ry, z, tx, ty));
	    xf86PostProximityEvent(local->dev, 1, 0, 5, rx, ry, z, rtx, rty);
	}
	if (!is_absolute)
	{
	    /* FIXME What's this good for ? */
	    priv->flags |= FIRST_TOUCH_FLAG;
	    DBG(4, ErrorF("xf86WacomSendEvents FIRST_TOUCH_FLAG set\n"));
	}
	priv->oldProximity = 1;
    }      

    /* Send ButtonRelease events when the stylus/cursor leaves the tablet;
     * this helps to avoid that the cursor on the screen jumps to the new
     * position when the stylus/cursor goes near the tablet again with
     * buttons pressed.
     * This also fixes all problems if a leave-event was missed (my
     * erase for example is missed somethimes while the tip works ok).
     */
    if (!is_proximity)
	buttons = 0;
    
    /* Tell X about which buttons have been pressed or released */
    if (priv->oldButtons != buttons)
    {
	int button;
	int bit;
	int isDown;

	/* These have changed */
	button = buttons ^ priv->oldButtons;
		
	while (button)
	{
	    bit = button & -button;
	    isDown = (buttons & bit) != 0;

	    DBG (4, ErrorF("xf86WacomSendEvents S2 PostButtonEvent %d %d %d 0 5 %5d %5d %4d %d %d\n", is_absolute, bit, isDown, rx, ry, rz, rtx, rty));
	    xf86PostButtonEvent(local->dev, is_absolute, bit, isDown,
			    0, 5, rx, ry, rz, rtx, rty); 
	    button ^= bit;
	}

	priv->oldButtons = buttons;
    }

    /* If we're near the table, tell X where we are */
    if (is_proximity)
    {
	DBG(14, ErrorF("xf86WacomSendEvents %s rx=%d ry=%d rz=%d priv->oldButtons=%d\n",
		  device == STYLUS_ID ? "stylus" : (
			device == ERASER_ID ? "eraser" : "cursor"),
		  rx, ry, rz, priv->oldButtons
	));

	/* Reduce jitter, etc. 
	 * FIXME The value '5' is probably way to small. What is
	 * wcmSuppress supposed to be ? */
	if (ABS(priv->oldX - x) > 5 ||
	    ABS(priv->oldY - y) > 5 ||
	    ABS(priv->oldZ - z) > 5 ||
	    (!is_core_pointer && device != CURSOR_ID && HANDLE_TILT(common) &&
	         (ABS(tx - priv->oldTiltX) > 5 || 
	          ABS(ty - priv->oldTiltY) > 5)
	    )
	)
	{
	    if (!is_absolute && (priv->flags & FIRST_TOUCH_FLAG))
	    {
		/* FIXME What's this good for ? */
		priv->flags -= FIRST_TOUCH_FLAG;
		DBG(4, ErrorF("xf86WacomSendEvents FIRST_TOUCH_FLAG unset\n"));
	    }
	    else
	    {
		/* Tell X that we have moved */
	        DBG (14, ErrorF("xf86WacomSendEvents S1 PostMotionEvent %d 0 5 %5d %5d %4d %d %d\n", rx, ry, z, rtx, rty));
		xf86PostMotionEvent(local->dev, is_absolute, 0, 5, rx, ry, rz,
				    rtx, rty); 
		priv->oldX = x;
		priv->oldY = y;
		priv->oldZ = z;
		priv->oldTiltX = tx;
		priv->oldTiltY = ty;
	    }
	}
    }
    else /* !is_proximity */
    {
	if (!is_core_pointer)
	{
#if 0 /* FIXME How is the pressure related to a key ?? */
	    /* macro button management */
	    if (buttons)
	    {
		int	macro = z / 2;

		DBG(6, ErrorF("macro=%d buttons=%d wacom_map[%d]=%x\n",
			      macro, buttons, macro, wacom_map[macro]));

		/* First available Keycode begins at 8 => macro+7 */
	        DBG (99, ErrorF("xf86WacomSendEvents S xf86PostKeyEvent\n"));
		xf86PostKeyEvent(local->dev, macro+7, 1,
				 is_absolute, 0, 5,
				 0, 0, buttons, rtx, rty);
	        DBG (99, ErrorF("xf86WacomSendEvents S xf86PostKeyEvent\n"));
		xf86PostKeyEvent(local->dev, macro+7, 0,
				 is_absolute, 0, 5,
				 0, 0, buttons, rtx, rty);
	    }
#endif
	    /* proximity only for non-core pointers (otherwise, the
	     * main cursor on the screen would vanish */
	    if (priv->oldProximity)
	    {
	        DBG (4, ErrorF("xf86WacomSendEvents S4 PostProximEvent     0 0 5 %5d %5d %4d %d %d\n", rx, ry, rz, rtx, rty));
		xf86PostProximityEvent(local->dev, 0, 0, 5, rx, ry, rz,
				       rtx, rty);
	    }
	}
	priv->oldProximity = 0;
    }
}

/*
 ***************************************************************************
 *
 * xf86WcmReadInput --
 *	Read the new events from the device, and enqueue them.
 *
 ***************************************************************************
 */
/* Was completely rewritten */
static void
xf86WcmReadInput (LocalDevicePtr local)
{
    WacomDevicePtr	priv = (WacomDevicePtr) local->private;
    WacomCommonPtr	common = priv->common;

    /* FIXME This is not very good; it would be much better to determine the
     * device and use the last values stored in there. Otherwise, we might
     * run into trouble when the device changes. */
    static int device = 0;
    static int is_proximity = 0;
    static int x = 0;
    static int y = 0;
    static int z = 0;
    static int buttons = 0;

    ssize_t              len;
    int                  idx;
    struct input_event * event;
    char                 eventbuf[BUFFER_SIZE];
#define MOD_BUTTONS(bit, value) \
    buttons = (((value) != 0) ? (buttons | bit) : (buttons & ~ bit))

    DBG(7, ErrorF("xf86WcmReadInput BEGIN device=%s fd=%d\n",
		  common->wcmDevice, local->fd));

    SYSCALL(len = read(local->fd, eventbuf, BUFFER_SIZE));

    if (len <= 0)
    {
	ErrorF("Error reading wacom device : %s\n", strerror(errno));
	return;
    }
    else
    {
	DBG(10, ErrorF("xf86WcmReadInput read %d bytes\n", len));
    }
    
    for (event=(struct input_event *)eventbuf;
	 event<(struct input_event *)(eventbuf+len); event++)
    {
	switch (event->type)
	{
	case EV_ABS:
	    switch (event->code)
	    {
	    case ABS_X:
		/* FIXME Why do we multiply by 2 ?? Wouldn't it make much
		 * more sense to reduce MaxX/MaxY ?? */
		x = event->value * 2;
		break;

	    case ABS_Y:
		y = event->value * 2;
		break;

	    case ABS_PRESSURE:
		z = event->value - 256;
		break;

	    case ABS_DISTANCE:
		/* This is not sent by the driver */
		break;
	    }
	    break; /* EV_ABS */

	case EV_REL:
	    switch (event->code)
	    {
	    case REL_WHEEL:
		/* FIXME */
		break;
	    }
	    break; /* EV_REL */

	case EV_KEY:
	    switch (event->code)
	    {
	    case BTN_TOOL_PEN:
		device = STYLUS_ID;
		is_proximity = (event->value != 0);
		break;

	    case BTN_TOOL_RUBBER:
		device = ERASER_ID;
		is_proximity = (event->value != 0);
		break;

	    case BTN_TOOL_MOUSE:
		device = CURSOR_ID;
		is_proximity = (event->value != 0);
		break;

	    case BTN_TOUCH:
		MOD_BUTTONS (1, event->value);
		break;

	    case BTN_STYLUS:
		MOD_BUTTONS (2, event->value);
		break;

	    case BTN_STYLUS2:
		MOD_BUTTONS (4, event->value);
		break;

	    case BTN_LEFT:
		MOD_BUTTONS (1, event->value);
		break;

	    case BTN_RIGHT:
		MOD_BUTTONS (2, event->value);
		break;

	    case BTN_MIDDLE:
		MOD_BUTTONS (4, event->value);
		break;
	    }
	    break; /* EV_KEY */
	} /* switch (event->type) */
    } /* for all read events */

    for (idx=0; idx<common->wcmNumDevices; idx++)
    {
	WacomDevicePtr dev;
	int            id;
	
	dev = common->wcmDevices[idx]->private;
	id  = DEVICE_ID (dev->flags);

	/* Find the device the current events are meant for */
	if (id == device)
	{
	    DBG(7, ErrorF("xf86WcmReadInput trying to send to %s\n",
		    common->wcmDevices[idx]->name));
	    xf86WcmSendEvents(common->wcmDevices[idx],
			device,
			is_proximity,
			x, y, z, buttons);
	}
    }
    DBG(7, ErrorF("xf86WcmReadInput END   local=0x%x priv=0x%x\n",
		  local, priv));
}

/*
 ***************************************************************************
 *
 * xf86WcmControlProc --
 *
 ***************************************************************************
 */
static void
xf86WcmControlProc(DeviceIntPtr	device,
		   PtrCtrl	*ctrl)
{
  DBG(2, ErrorF("xf86WcmControlProc\n"));
}

/*
 ***************************************************************************
 *
 * xf86WcmOpen --
 *
 ***************************************************************************
 */
static Bool
xf86WcmOpen(LocalDevicePtr	local)
{
    struct timeval	timeout;
    char		buffer[256];
    int			err;
    WacomDevicePtr	priv = (WacomDevicePtr)local->private;
    WacomCommonPtr	common = priv->common;
    int			a, b;
    int			loop, idx;
    int			is_a_penpartner = 0;
    
    DBG(1, ErrorF("opening %s\n", common->wcmDevice));

    /* Original xf86wacom's initialization procedure was very complex.
     * The USB version is simple, just open the device. It would be nice
     * if I could get the firmware version or something */
    SYSCALL(local->fd = open(common->wcmDevice, O_RDONLY|O_NDELAY, 0));
    if (local->fd == -1) {
	ErrorF("Error opening %s : %s\n", common->wcmDevice, strerror(errno));
	return !Success;
    }

    DBG(1, ErrorF("initializing tablet\n"));
    /* Some commands used by original xf86wacom is not implemented by 
     * Linux-USB. These are: get resolution parameter (wcmResolX, wcmResolY,
     * wcmMaxX, wcmMaxY) from the tablet and enter the tild mode. */
    /* sscanf(buffer+19, "%d,%d,%d,%d", &a, &b, &common->wcmResolX, &common->wcmResolY); */
    /* KANJI penpartner ƥǥ벿ΤФƤΤʡ*/
    
    DBG(2, ErrorF("setup is max X=%d max Y=%d resol X=%d resol Y=%d\n",
		  common->wcmMaxX, common->wcmMaxY, common->wcmResolX,
		  common->wcmResolY));
  
    /* send the tilt mode command after setup because it must be enabled */
    /* after multi-mode to take precedence */
    if (HANDLE_TILT(common)) {
      /* Unfortunately, the USB driver doesn't allow to send this
       * command to the tablet. Any other solutions ? */
	DBG(2, ErrorF("Sending tilt mode order\n"));
    }
  
    {
	char	buf[20];
      
	if (common->wcmSuppress < 0) {
	    common->wcmSuppress = 0;
	} else {
	    if (common->wcmSuppress > 100) {
		common->wcmSuppress = 99;
	    }
	}
	/* Cannot send WC_SUPPRESS to the table. Will have to do
	 * this manually. */
    }
    
    if (xf86Verbose)
	ErrorF("%s Wacom tablet maximum X=%d maximum Y=%d "
	       "X resolution=%d Y resolution=%d suppress=%d%s\n",
	       XCONFIG_PROBED, common->wcmMaxX, common->wcmMaxY,
	       common->wcmResolX, common->wcmResolY, common->wcmSuppress,
	       HANDLE_TILT(common) ? " Tilt" : "");
  
    if (err <= 0) {
	SYSCALL(close(local->fd));
	return !Success;
    }

    return Success;
}

/*
 ***************************************************************************
 *
 * xf86WcmOpenDevice --
 *	Open the physical device and init information structs.
 *
 ***************************************************************************
 */
static int
xf86WcmOpenDevice(DeviceIntPtr       pWcm)
{
    LocalDevicePtr	local = (LocalDevicePtr)pWcm->public.devicePrivate;
    WacomDevicePtr	priv = (WacomDevicePtr)PRIVATE(pWcm);
    WacomCommonPtr	common = priv->common;
    double		screenRatio, tabletRatio;
    int			gap;
    int			loop;
    
    if (local->fd < 0) {
	if (xf86WcmOpen(local) != Success) {
	    if (local->fd >= 0) {
		SYSCALL(close(local->fd));
	    }
	    local->fd = -1;
	}
	else {
	    /* report the file descriptor to all devices */
	    for(loop=0; loop<common->wcmNumDevices; loop++) {
		common->wcmDevices[loop]->fd = local->fd;
	    }
	}
    }

    if (local->fd != -1 &&
	priv->factorX == 0.0) {
	
	if (priv->bottomX == 0) priv->bottomX = common->wcmMaxX;

	if (priv->bottomY == 0) priv->bottomY = common->wcmMaxY;

	/* Verify Box validity */

	if (priv->topX > common->wcmMaxX ||
	    priv->topX < 0) {
	    ErrorF("Wacom invalid TopX (%d) reseting to 0\n", priv->topX);
	    priv->topX = 0;
	}

	if (priv->topY > common->wcmMaxY ||
	    priv->topY < 0) {
	    ErrorF("Wacom invalid TopY (%d) reseting to 0\n", priv->topY);
	    priv->topY = 0;
	}

	if (priv->bottomX > common->wcmMaxX ||
	    priv->bottomX < priv->topX) {
	    ErrorF("Wacom invalid BottomX (%d) reseting to %d\n",
		   priv->bottomX, common->wcmMaxX);
	    priv->bottomX = common->wcmMaxX;
	}

	if (priv->bottomY > common->wcmMaxY ||
	    priv->bottomY < priv->topY) {
	    ErrorF("Wacom invalid BottomY (%d) reseting to %d\n",
		   priv->bottomY, common->wcmMaxY);
	    priv->bottomY = common->wcmMaxY;
	}
    
	/* Calculate the ratio according to KeepShape, TopX and TopY */

	if (priv->flags & KEEP_SHAPE_FLAG) {
	    screenRatio = ((double) screenInfo.screens[0]->width)
		/ screenInfo.screens[0]->height;

	    tabletRatio = ((double) (common->wcmMaxX - priv->topX))
		/ (common->wcmMaxY - priv->topY);

	    DBG(2, ErrorF("screenRatio = %.3g, tabletRatio = %.3g\n",
			  screenRatio, tabletRatio));

	    if (screenRatio > tabletRatio) {
		gap = common->wcmMaxY * (1 - tabletRatio/screenRatio);
		priv->bottomX = common->wcmMaxX;
		priv->bottomY = common->wcmMaxY - gap;
	    } else {
		gap = common->wcmMaxX * (1 - screenRatio/tabletRatio);
		priv->bottomX = common->wcmMaxX - gap;
		priv->bottomY = common->wcmMaxY;
	    }
	}
	priv->factorX = ((double) screenInfo.screens[0]->width)
	    / (priv->bottomX - priv->topX);
	priv->factorY = ((double) screenInfo.screens[0]->height)
	    / (priv->bottomY - priv->topY);
    
	if (xf86Verbose)
	    ErrorF("%s Wacom tablet top X=%d top Y=%d "
		   "bottom X=%d bottom Y=%d\n",
		   XCONFIG_PROBED, priv->topX, priv->topY,
		   priv->bottomX, priv->bottomY);
	
	DBG(2, ErrorF("X factor = %.3g, Y factor = %.3g\n",
		      priv->factorX, priv->factorY));
    }
    
    /* Set the real values */
    InitValuatorAxisStruct(pWcm,
			   0,
			   0, /* min val */
			   priv->bottomX - priv->topX, /* max val */
			   mils(common->wcmResolX), /* resolution */
			   0, /* min_res */
			   mils(common->wcmResolX)); /* max_res */
    InitValuatorAxisStruct(pWcm,
			   1,
			   0, /* min val */
			   priv->bottomY - priv->topY, /* max val */
			   mils(common->wcmResolY), /* resolution */
			   0, /* min_res */
			   mils(common->wcmResolY)); /* max_res */
    InitValuatorAxisStruct(pWcm,
			   2,
			   - common->wcmMaxZ / 2, /* min val */
			   common->wcmMaxZ / 2, /* max val */
			   mils(common->wcmResolZ), /* resolution */
			   0, /* min_res */
			   mils(common->wcmResolZ)); /* max_res */
    InitValuatorAxisStruct(pWcm,
			   3,
			   -64,		/* min val */
			   63,		/* max val */
			   128,		/* resolution ??? */
			   0,
			   128);
    InitValuatorAxisStruct(pWcm,
			   4,
			   -64,		/* min val */
			   63,		/* max val */
			   128,		/* resolution ??? */
			   0,
			   128);
    
    return (local->fd != -1);
}

/*
 ***************************************************************************
 *
 * xf86WcmClose --
 *
 ***************************************************************************
 */
static void
xf86WcmClose(LocalDevicePtr	local)
{
    WacomDevicePtr	priv = (WacomDevicePtr)local->private;
    WacomCommonPtr	common = priv->common;
    int			loop;
    int			num = 0;
    
    for(loop=0; loop<common->wcmNumDevices; loop++) {
	if (common->wcmDevices[loop]->fd >= 0) {
	    num++;
	}
    }
    DBG(4, ErrorF("Wacom number of open devices = %d\n", num));
    
    if (num == 1) {		    
	SYSCALL(close(local->fd));
    }
    
    local->fd = -1;
}

/*
 ***************************************************************************
 *
 * xf86WcmProc --
 *      Handle the initialization, etc. of a wacom
 *
 ***************************************************************************
 */
static int
xf86WcmProc(DeviceIntPtr       pWcm,
	    int                what)
{
    CARD8                 map[(32 << 4) + 1];
    int                   nbaxes;
    int                   nbbuttons;
    KeySymsRec            keysyms;
    int                   loop;
    LocalDevicePtr        local = (LocalDevicePtr)pWcm->public.devicePrivate;
    WacomDevicePtr        priv = (WacomDevicePtr)PRIVATE(pWcm);
  
    DBG(2, ErrorF("BEGIN xf86WcmProc dev=0x%x priv=0x%x type=%s flags=%d what=%d\n",
		  pWcm, priv, (DEVICE_ID(priv->flags) == STYLUS_ID) ? "stylus" :
		  (DEVICE_ID(priv->flags) == CURSOR_ID) ? "cursor" : "eraser",
		  priv->flags, what));
  
    switch (what)
	{
	case DEVICE_INIT: 
	    DBG(1, ErrorF("xf86WcmProc pWcm=0x%x what=INIT\n", pWcm));
      
	    nbaxes = 5;			/* X, Y, Pressure, Tilt-X, Tilt-Y */
	    
	    switch(DEVICE_ID(priv->flags)) {
	    case ERASER_ID:
		nbbuttons = 1;
		break;
	    case STYLUS_ID:
		nbbuttons = 4;
		break;
	    default:
		nbbuttons = 16;
		break;
	    }
	    
	    for(loop=1; loop<=nbbuttons; loop++) map[loop] = loop;

	    if (InitButtonClassDeviceStruct(pWcm,
					    nbbuttons,
					    map) == FALSE) {
		ErrorF("unable to allocate Button class device\n");
		return !Success;
	    }
      
	    if (InitFocusClassDeviceStruct(pWcm) == FALSE) {
		ErrorF("unable to init Focus class device\n");
		return !Success;
	    }
          
	    if (InitPtrFeedbackClassDeviceStruct(pWcm,
						 xf86WcmControlProc) == FALSE) {
		ErrorF("unable to init ptr feedback\n");
		return !Success;
	    }
	    
	    if (InitProximityClassDeviceStruct(pWcm) == FALSE) {
		ErrorF("unable to init proximity class device\n");
		return !Success;
	    }

	    if (InitKeyClassDeviceStruct(pWcm, &wacom_keysyms, NULL) == FALSE) {
		ErrorF("unable to init key class device\n"); 
		return !Success;
	    }

	    if (InitValuatorClassDeviceStruct(pWcm, 
					      nbaxes,
					      xf86GetMotionEvents, 
					      local->history_size,
					      (priv->flags & ABSOLUTE_FLAG) 
					      ? Absolute : Relative)
		== FALSE) {
		ErrorF("unable to allocate Valuator class device\n"); 
		return !Success;
	    }
	    else {
		/* allocate the motion history buffer if needed */
		xf86MotionHistoryAllocate(local);

		AssignTypeAndName(pWcm, local->atom, local->name);
	    }

	    /* open the device to gather informations */
	    xf86WcmOpenDevice(pWcm);

	    break; 
      
	case DEVICE_ON:
	    DBG(1, ErrorF("xf86WcmProc pWcm=0x%x what=ON\n", pWcm));

	    if ((local->fd < 0) && (!xf86WcmOpenDevice(pWcm))) {
		return !Success;
	    }      
	    AddEnabledDevice(local->fd);
	    pWcm->public.on = TRUE;
	    break;
      
	case DEVICE_OFF:
	    DBG(1, ErrorF("xf86WcmProc  pWcm=0x%x what=%s\n", pWcm,
			  (what == DEVICE_CLOSE) ? "CLOSE" : "OFF"));
	    if (local->fd >= 0)
		RemoveEnabledDevice(local->fd);
	    pWcm->public.on = FALSE;
	    break;
      
	case DEVICE_CLOSE:
	    DBG(1, ErrorF("xf86WcmProc  pWcm=0x%x what=%s\n", pWcm,
			  (what == DEVICE_CLOSE) ? "CLOSE" : "OFF"));
	    xf86WcmClose(local);
	    break;

	default:
	    ErrorF("unsupported mode=%d\n", what);
	    return !Success;
	    break;
	}
    DBG(2, ErrorF("END   xf86WcmProc Success what=%d dev=0x%x priv=0x%x\n",
		  what, pWcm, priv));
    return Success;
}

/*
 ***************************************************************************
 *
 * xf86WcmChangeControl --
 *
 ***************************************************************************
 */
static int
xf86WcmChangeControl(LocalDevicePtr	local,
		     xDeviceCtl		*control)
{
    xDeviceResolutionCtl	*res;
    int				*resolutions;
    char			str[10];
  
    res = (xDeviceResolutionCtl *)control;
	
    if ((control->control != DEVICE_RESOLUTION) ||
	(res->num_valuators < 1))
	return (BadMatch);
  
    resolutions = (int *)(res +1);
    
    DBG(3, ErrorF("xf86WcmChangeControl changing to %d (suppressing under)\n",
		  resolutions[0]));

    /* ǥޥ... throw command in here... */
    return(Success);
}

/*
 ***************************************************************************
 *
 * xf86WcmSwitchMode --
 *
 ***************************************************************************
 */
static int
xf86WcmSwitchMode(ClientPtr	client,
		  DeviceIntPtr	dev,
		  int		mode)
{
    LocalDevicePtr        local = (LocalDevicePtr)dev->public.devicePrivate;
    WacomDevicePtr        priv = (WacomDevicePtr)local->private;

    DBG(3, ErrorF("xf86WcmSwitchMode dev=0x%x mode=%d\n", dev, mode));
  
    if (mode == Absolute) {
	priv->flags = priv->flags | ABSOLUTE_FLAG;
    }
    else {
	if (mode == Relative) {
	    priv->flags = priv->flags & ~ABSOLUTE_FLAG; 
	}
	else {
	    DBG(1, ErrorF("xf86WcmSwitchMode dev=0x%x invalid mode=%d\n", dev,
			  mode));
	    return BadMatch;
	}
    }
    return Success;
}

/*
 ***************************************************************************
 *
 * xf86WcmAllocate --
 *
 ***************************************************************************
 */
static LocalDevicePtr
xf86WcmAllocate(char *  name,
                int     flag)
{
    LocalDevicePtr        local = (LocalDevicePtr) xalloc(sizeof(LocalDeviceRec));
    WacomDevicePtr        priv = (WacomDevicePtr) xalloc(sizeof(WacomDeviceRec));
    WacomCommonPtr        common = (WacomCommonPtr) xalloc(sizeof(WacomCommonRec));
#if defined(sun) && !defined(i386)
    char			*dev_name = (char *) getenv("WACOM_DEV");  
#endif

    local->name = name;
    local->flags = 0; /*XI86_NO_OPEN_ON_INIT;*/
#if !defined(sun) || defined(i386)
    local->device_config = xf86WcmConfig;
#endif
    local->device_control = xf86WcmProc;
    local->read_input = xf86WcmReadInput;
    local->control_proc = xf86WcmChangeControl;
    local->close_proc = xf86WcmClose;
    local->switch_mode = xf86WcmSwitchMode;
    local->fd = -1;
    local->atom = 0;
    local->dev = NULL;
    local->private = priv;
    local->private_flags = 0;
    local->history_size  = 0;

    priv->flags = flag;			/* various flags (device type, absolute, first touch...) */
    priv->oldX = -1;			/* previous X position */
    priv->oldY = -1;			/* previous Y position */
    priv->oldZ = -1;			/* previous pressure */
    priv->oldTiltX = -1;		/* previous tilt in x direction */
    priv->oldTiltY = -1;		/* previous tilt in y direction */
    priv->oldButtons = 0;		/* previous buttons state */
    priv->oldProximity = 0;		/* previous proximity */
    priv->topX = 0;			/* X top */
    priv->topY = 0;			/* Y top */
    priv->bottomX = 0;			/* X bottom */
    priv->bottomY = 0;			/* Y bottom */
    priv->factorX = 0.0;		/* X factor */
    priv->factorY = 0.0;		/* Y factor */
    priv->common = common;		/* common info pointer */
    
    common->wcmDevice = "";		/* device file name */
    common->wcmDeviceType = DEVICE_ID(flag);	/* device file name */
#if defined(sun) && !defined(i386)
    if (dev_name) {
	common->wcmDevice = (char*) xalloc(strlen(dev_name)+1);
	strcpy(common->wcmDevice, dev_name);
	ErrorF("xf86WcmOpen port changed to '%s'\n", common->wcmDevice);
    }
#endif
    common->wcmSuppress = 10;		/* transmit position if increment is superior */
    common->wcmFlags = 0;		/* various flags */
    common->wcmDevices = (LocalDevicePtr*) xalloc(sizeof(LocalDevicePtr));
    common->wcmDevices[0] = local;
    common->wcmNumDevices = 1;		/* number of devices */
    common->wcmIndex = 0;		/* number of bytes read */
    common->wcmPktLength = 7;		/* length of a packet */
    //common->wcmMaxX = 22860;		/* max X value */
    //common->wcmMaxY = 15240;		/* max Y value */
    //common->wcmMaxZ = 512;		/* max Z value */
    common->wcmMaxX = 20412;            /* max X value */
    common->wcmMaxY = 14840;		/* max Y value */
    common->wcmMaxZ = 511;		/* max Z value */
    common->wcmResolX = 1270;		/* X resolution in points/inch */
    common->wcmResolY = 1270;		/* Y resolution in points/inch */
    common->wcmResolZ = 1270;		/* Z resolution in points/inch */ /* ? */
    common->wcmHasEraser = (flag & ERASER_ID) ? TRUE : FALSE;	/* True if an eraser has been configured */

    return local;
}

/*
 ***************************************************************************
 *
 * xf86WcmAllocateStylus --
 *
 ***************************************************************************
 */
static LocalDevicePtr
xf86WcmAllocateStylus()
{
    LocalDevicePtr        local = xf86WcmAllocate(XI_STYLUS, STYLUS_ID);

    local->type_name = "Wacom Stylus";
    return local;
}

/*
 ***************************************************************************
 *
 * xf86WcmAllocateCursor --
 *
 ***************************************************************************
 */
static LocalDevicePtr
xf86WcmAllocateCursor()
{
    LocalDevicePtr        local = xf86WcmAllocate(XI_CURSOR, CURSOR_ID);

    local->type_name = "Wacom Cursor";
    return local;
}

/*
 ***************************************************************************
 *
 * xf86WcmAllocateEraser --
 *
 ***************************************************************************
 */
static LocalDevicePtr
xf86WcmAllocateEraser()
{
    LocalDevicePtr        local = xf86WcmAllocate(XI_ERASER, ABSOLUTE_FLAG|ERASER_ID);

    local->type_name = "Wacom Eraser";
    return local;
}

/*
 ***************************************************************************
 *
 * Wacom Stylus device association --
 *
 ***************************************************************************
 */
DeviceAssocRec wacom_stylus_assoc =
{
    STYLUS_SECTION_NAME,		/* config_section_name */
    xf86WcmAllocateStylus		/* device_allocate */
};

/*
 ***************************************************************************
 *
 * Wacom Cursor device association --
 *
 ***************************************************************************
 */
DeviceAssocRec wacom_cursor_assoc =
{
    CURSOR_SECTION_NAME,		/* config_section_name */
    xf86WcmAllocateCursor		/* device_allocate */
};

/*
 ***************************************************************************
 *
 * Wacom Eraser device association --
 *
 ***************************************************************************
 */
DeviceAssocRec wacom_eraser_assoc =
{
    ERASER_SECTION_NAME,		/* config_section_name */
    xf86WcmAllocateEraser		/* device_allocate */
};

#ifdef DYNAMIC_MODULE
/*
 ***************************************************************************
 *
 * entry point of dynamic loading
 *
 ***************************************************************************
 */
int
#ifndef DLSYM_BUG
init_module(unsigned long	server_version)
#else
init_xf86Wacom(unsigned long    server_version)
#endif
{
    xf86AddDeviceAssoc(&wacom_stylus_assoc);
    xf86AddDeviceAssoc(&wacom_cursor_assoc);
    xf86AddDeviceAssoc(&wacom_eraser_assoc);

    if (server_version != XF86_VERSION_CURRENT) {
	ErrorF("Warning: Wacom module compiled for version%s\n", XF86_VERSION);
	return 0;
    } else {
	return 1;
    }
}
#endif


#ifdef TEST
/* Test code */
#include <stdarg.h>
#include <stdlib.h>
int xf86Verbose = 1;

ScreenInfo screenInfo;
ScreenRec dummyScreen;

LocalDevicePtr localDevices[10];
int num_devices = 0;

LocalDevicePtr   switch_device;
InputInfo inputInfo;

TimeStamp currentTime;

static SymTabRec XinputTab[] = {
  { ENDSECTION,         "endsection"},
  { SUBSECTION,         "subsection" },
  { DEBUG_LEVEL,        "debuglevel" },
  { -1,                 "" },
};

void ErrorF (char * fmt, ...)
{
    va_list args;

    va_start (args, fmt);
    vfprintf (stderr, fmt, args);
    va_end (args);
}

void xf86ConfigError (char * msg)
{
    ErrorF ("xf86ConfigError %s\n", msg);
    exit (0);
}

void FatalError (char * fmt, ...)
{
    va_list args;

    va_start (args, fmt);
    vfprintf (stderr, fmt, args);
    va_end (args);
    exit (0);
}

Bool InitButtonClassDeviceStruct (DeviceIntPtr dev, int numButtons, CARD8* map)
{
    register ButtonClassPtr butc;
    int i;

    butc = (ButtonClassPtr)xalloc(sizeof(ButtonClassRec));
    if (!butc)
        return FALSE;
    butc->numButtons = numButtons;
    for (i = 1; i <= numButtons; i++)
        butc->map[i] = map[i];
    butc->buttonsDown = 0;
    butc->state = 0;
    butc->motionMask = 0;
    bzero((char *)butc->down, DOWN_LENGTH);
#ifdef XKB
    butc->xkb_acts=     NULL;
#endif
    dev->button = butc;
    return TRUE;
}

Bool InitFocusClassDeviceStruct (DeviceIntPtr dev)
{
    register FocusClassPtr focc;

    focc = (FocusClassPtr)xalloc(sizeof(FocusClassRec));
    if (!focc)
        return FALSE;
    focc->win = PointerRootWin;
    focc->revert = None;
    focc->time = currentTime;
    focc->trace = (WindowPtr *)NULL;
    focc->traceSize = 0;
    focc->traceGood = 0;
    dev->focus = focc;
    return TRUE;
}

Bool InitPtrFeedbackClassDeviceStruct (DeviceIntPtr dev, PtrCtrlProcPtr controlProc)
{
}

Bool InitProximityClassDeviceStruct (DeviceIntPtr dev)
{
}

Bool InitKeyClassDeviceStruct (DeviceIntPtr dev, KeySymsPtr pKeySyms,
    CARD8 pModifiers[])
{
}

Bool InitValuatorClassDeviceStruct (DeviceIntPtr dev, int numAxes,
    ValuatorMotionProcPtr motionProc, int numMotionEvents, int mode)
{
    int i;
    register ValuatorClassPtr valc;

    valc = (ValuatorClassPtr)xalloc(sizeof(ValuatorClassRec) +
                                    numAxes * sizeof(AxisInfo) +
                                    numAxes * sizeof(unsigned int));
    if (!valc)
        return FALSE;
    valc->GetMotionProc = motionProc;
    valc->numMotionEvents = numMotionEvents;
    valc->motionHintWindow = NullWindow;
    valc->numAxes = numAxes;
    valc->mode = mode;
    valc->axes = (AxisInfoPtr)(valc + 1);
    valc->axisVal = (int *)(valc->axes + numAxes);
    for (i=0; i<numAxes; i++)
        valc->axisVal[i]=0;
    dev->valuator = valc;
    return TRUE;
}

unsigned long *Xalloc (unsigned long size)
{
    return malloc (size);
}

void Xfree (pointer data)
{
    free (data);
}

unsigned long *Xrealloc (pointer data, unsigned long size)
{
    return realloc (data, size);
}

struct Config
{
    int type;
    char * str;
}
* configData, stylusConfig[] =
{
    { DEVICENAME, },
    { STRING, "Stylus", },
    { PORT, },
    { STRING, "/dev/input/event0", },
    { THE_MODE, },
    { ABSOLUTE, },
    { ENDSUBSECTION, },
},
cursorConfig[] =
{
    { DEVICENAME, },
    { STRING, "Cursor", },
    { PORT, },
    { STRING, "/dev/input/event0", },
    { THE_MODE, },
    { ABSOLUTE, },
    { ENDSUBSECTION, },
},
eraserConfig[] =
{
    { DEVICENAME, },
    { STRING, "Eraser", },
    { PORT, },
    { STRING, "/dev/input/event0", },
    { THE_MODE, },
    { ABSOLUTE, },
    { ENDSUBSECTION, },
};
struct Config * configs[] = {
    stylusConfig,
    cursorConfig,
    eraserConfig,
};
LexRec lex;

int configIdx = 0;

int xf86GetToken (SymTabPtr table)
{
    lex.str = configData[configIdx].str;
    return configData[configIdx ++].type;
}

void xf86AlwaysCore (LocalDevicePtr local, Bool always)
{
}

DeviceAssocPtr deviceAssoc[10];
int numAssoc = 0;

void xf86AddDeviceAssoc (DeviceAssocPtr assoc)
{
    deviceAssoc[numAssoc] = assoc;
    numAssoc++;
}

void InitValuatorAxisStruct (DeviceIntPtr prt,
    int axnum, int minval, int maxval,
    int resolution, int min_res, int max_res)
{
}

int RemoveEnabledDevice (int fd)
{
}

int AddEnabledDevice (int fd)
{
}

void AssignTypeAndName (DeviceIntPtr dev, Atom type, char * name)
{
}

void xf86MotionHistoryAllocate (LocalDevicePtr local)
{
}

int xf86GetMotionEvents (DeviceIntPtr dev, xTimecoord *buff,
    unsigned long start, unsigned long stop, ScreenPtr pScreen)
{
}

void xf86PostKeyEvent (DeviceIntPtr dev, unsigned int key_code,
    int is_down, int is_absolute, int first_valuator, int num_valuators,
    ...)
{
}

void xf86PostButtonEvent (DeviceIntPtr dev, int is_absolute,
    int button, int is_down, int first_valuator, int num_valuators,
    ...)
{
}

void xf86PostProximityEvent (DeviceIntPtr dev, int is_in,
    int first_valuator, int num_valuators, ...)
{
}

void xf86PostMotionEvent (DeviceIntPtr dev, int is_absolute,
    int first_valuator, int num_valuators, ...)
{
}

int xf86IsCorePointer (DeviceIntPtr dev)
{
    return (dev == inputInfo.pointer);
}

static void
xf86AlwaysCoreControl(DeviceIntPtr      device,
                      IntegerCtrl       *control)
{
}

void
xf86XinputFinalizeInit(DeviceIntPtr     dev)
{
    LocalDevicePtr        local = (LocalDevicePtr)dev->public.devicePrivate;

    local->dxremaind = 0.0;
    local->dyremaind = 0.0;
    
    if (InitIntegerFeedbackClassDeviceStruct(dev, xf86AlwaysCoreControl) == FALSE) {
        ErrorF("Unable to init integer feedback for always core feature\n");
    } else {
        local->always_core_feedback = dev->intfeed;
        dev->intfeed->ctrl.integer_displayed = (local->flags & XI86_ALWAYS_CORE);
    }
}

Bool
InitIntegerFeedbackClassDeviceStruct (dev, controlProc)
    DeviceIntPtr dev;
    IntegerCtrlProcPtr controlProc;
{
    register IntegerFeedbackPtr feedc;

    feedc = (IntegerFeedbackPtr)xalloc(sizeof(IntegerFeedbackClassRec));
    if (!feedc)
        return FALSE;
    feedc->CtrlProc = controlProc;
    //feedc->ctrl = defaultIntegerControl;
    feedc->ctrl.id = 0;
    if ( (feedc->next = dev->intfeed) )
        feedc->ctrl.id = dev->intfeed->ctrl.id + 1;
    dev->intfeed = feedc;
    (*controlProc)(dev, &feedc->ctrl);
    return TRUE;
}


struct AtomData
{
    char string[100];
    Atom a;
} atoms[100];
int lastAtom = 0;

Atom MakeAtom (char * string, unsigned len, Bool makeit)
{
    int i;
    for (i=0; i<lastAtom; i++)
	if (!strncmp (atoms[i].string, string, len))
	    return atoms[i].a;

    if (!makeit)
	return None;

    strncpy (atoms[lastAtom].string, string ,len);
    atoms[lastAtom].string[len] = 0;
    atoms[lastAtom].a = lastAtom ++;
    return lastAtom - 1;
}

int main (int argc, char ** argv)
{
    int i;
    DeviceIntPtr dev;
    fd_set fdset;

    screenInfo.screens[0] = &dummyScreen;
    dummyScreen.width = 1280;
    dummyScreen.height = 1024;
    
    init_module (XF86_VERSION_CURRENT);

    for (i=0; i<numAssoc; i++)
    {
	configIdx = 0;
	configData = configs[i];
	localDevices[num_devices] = deviceAssoc[i]->device_allocate ();
	(*localDevices[num_devices]->device_config)(localDevices,
	      num_devices, num_devices+1, &lex);
	localDevices[num_devices]->flags |= XI86_CONFIGURED;
        num_devices++;
    }
    
    for (i=0; i<numAssoc; i++)
    {
	dev = (DeviceIntPtr) xalloc(sizeof(DeviceIntRec));
	dev->name = (char *)NULL;
    dev->type = 0;
    dev->id = inputInfo.numDevices;
    inputInfo.numDevices++;
    dev->public.on = FALSE;
    //dev->public.processInputProc = (ProcessInputProc)NoopDDA;
    //dev->public.realInputProc = (ProcessInputProc)NoopDDA;
    //dev->public.enqueueInputProc = EnqueueEvent;
    dev->deviceProc = localDevices[i]->device_control;
    dev->startup = 1;
    dev->sync.frozen = FALSE;
    dev->sync.other = NullGrab;
    dev->sync.state = NOT_GRABBED;
    dev->sync.event = (xEvent *) NULL;
    dev->sync.evcount = 0;
    dev->grab = NullGrab;
    dev->grabTime = currentTime;
    dev->fromPassiveGrab = FALSE;
    dev->key = (KeyClassPtr)NULL;
    dev->valuator = (ValuatorClassPtr)NULL;
    dev->button = (ButtonClassPtr)NULL;
    dev->focus = (FocusClassPtr)NULL;
    dev->proximity = (ProximityClassPtr)NULL;
    dev->kbdfeed = (KbdFeedbackPtr)NULL;
    dev->ptrfeed = (PtrFeedbackPtr)NULL;
    dev->intfeed = (IntegerFeedbackPtr)NULL;
    dev->stringfeed = (StringFeedbackPtr)NULL;
dev->bell = (BellFeedbackPtr)NULL;
    dev->leds = (LedFeedbackPtr)NULL;
    dev->next = inputInfo.off_devices;
#ifdef XKB
    dev->xkb_interest= NULL;
#endif
    inputInfo.off_devices = dev;

    localDevices[i]->atom = MakeAtom(localDevices[i]->name,
                                             strlen(localDevices[i]->name),
                                             TRUE);
            dev->public.devicePrivate = (pointer) localDevices[i];
            localDevices[i]->dev = dev;      
	    xf86XinputFinalizeInit (dev);

	    localDevices[i]->device_control (dev, DEVICE_INIT);
    }
    
    while (1)
    {
	FD_ZERO(&fdset);
	FD_SET(localDevices[0]->fd, &fdset);
	select (localDevices[0]->fd+1, &fdset, NULL, NULL, NULL);
	localDevices[0]->read_input (localDevices[0]);
    }
    
    return 0;
}

#endif

/* end of xf86Wacom.c */
