#ifndef __LINUX_se401_H
#define __LINUX_se401_H

//#include <linux/list.h>

#define SE401_DEBUG	/* Turn on debug messages */

#ifdef SE401_DEBUG
#  define PDEBUG(fmt, args...) printk("se401: " fmt "\n" , ## args)
#else
#  define PDEBUG(fmt, args...) do {} while(0)
#endif

/* Camera interface register numbers */
#define se401_REG_CAMERA_DELAY_MODE			0x10
#define se401_REG_CAMERA_EDGE_MODE			0x11
#define se401_REG_CAMERA_CLAMPED_PIXEL_NUM	0x12
#define se401_REG_CAMERA_CLAMPED_LINE_NUM	0x13
#define se401_REG_CAMERA_PIXEL_DIVISOR		0x14
#define se401_REG_CAMERA_LINE_DIVISOR		0x15
#define se401_REG_CAMERA_DATA_INPUT_SELECT	0x16
#define se401_REG_CAMERA_RESERVED_LINE_MODE	0x17
#define se401_REG_CAMERA_BITMASK			0x18

/* Snapshot mode camera interface register numbers */
#define se401_REG_SNAP_CAPTURED_FRAME		0x19
#define se401_REG_SNAP_CLAMPED_PIXEL_NUM	0x1A
#define se401_REG_SNAP_CLAMPED_LINE_NUM		0x1B
#define se401_REG_SNAP_PIXEL_DIVISOR		0x1C
#define se401_REG_SNAP_LINE_DIVISOR			0x1D
#define se401_REG_SNAP_DATA_INPUT_SELECT	0x1E
#define se401_REG_SNAP_BITMASK				0x1F

/* DRAM register numbers */
#define se401_REG_DRAM_ENABLE_FLOW_CONTROL	0x20
#define se401_REG_DRAM_READ_CYCLE_PREDICT	0x21
#define se401_REG_DRAM_MANUAL_READ_CYCLE	0x22
#define se401_REG_DRAM_REFRESH_COUNTER		0x23

/* ISO FIFO register numbers */
#define se401_REG_FIFO_PACKET_SIZE			0x30
#define se401_REG_FIFO_BITMASK				0x31

/* PIO register numbers */
#define se401_REG_PIO_BITMASK				0x38
#define se401_REG_PIO_DATA_PORT				0x39
#define se401_REG_PIO_BIST					0x3E


/* I2C snapshot register numbers */
#define se401_REG_I2C_SNAP_SUB_ADDRESS		0x48
#define se401_REG_I2C_SNAP_DATA_PORT		0x49

/* System control register numbers */
#define se401_REG_SYSTEM_RESET				0x50
#define 	se401_RESET_UDC				0x01
#define 	se401_RESET_I2C				0x02
#define 	se401_RESET_FIFO			0x04
#define 	se401_RESET_OMNICE			0x08
#define 	se401_RESET_DRAM_INTF		0x10
#define 	se401_RESET_CAMERA_INTF		0x20
#define		se401_RESET_se401			0x40
#define		se401_RESET_NOREGS			0x3F	/* All but se401 & regs */
#define 	se401_RESET_ALL				0x7F
#define se401_REG_SYSTEM_CLOCK_DIVISOR		0x51
#define se401_REG_SYSTEM_SNAPSHOT			0x52
#define se401_REG_SYSTEM_INIT         		0x53
#define se401_REG_SYSTEM_USER_DEFINED		0x5E
#define se401_REG_SYSTEM_CUSTOM_ID			0x5F


/* Alternate numbers for various max packet sizes */
#define SE401_ALTERNATE_SIZE_992	0
#define SE401_ALTERNATE_SIZE_993	1
#define SE401_ALTERNATE_SIZE_768	2
#define SE401_ALTERNATE_SIZE_769	3
#define SE401_ALTERNATE_SIZE_512	4
#define SE401_ALTERNATE_SIZE_513	5
#define SE401_ALTERNATE_SIZE_257	6
#define SE401_ALTERNATE_SIZE_0		7


#define STREAM_BUF_SIZE	(PAGE_SIZE * 4)

#define SCRATCH_BUF_SIZE 384

#define FRAMES_PER_DESC		10  /* FIXME - What should this be? */
#define FRAME_SIZE_PER_DESC	993	/* FIXME - Shouldn't be hardcoded */

// FIXME - should this be 0x81 (endpoint address) or 0x01 (endpoint number)?
#define SE401_ENDPOINT_ADDRESS 0x81 /* Address of isoc endpoint */


/* Prototypes */
int usb_se401_reg_read(struct usb_device *dev, unsigned char reg);
int usb_se401_reg_write(struct usb_device *dev,
                        unsigned char reg,
                        unsigned char value);


enum {
	STATE_SCANNING,		/* Scanning for start */
	STATE_HEADER,		/* Parsing header */
	STATE_LINES,		/* Parsing lines */
};

struct usb_device;

struct se401_sbuf {
	char *data;
	urb_t *urb;
};

enum {
	FRAME_UNUSED,		/* Unused (no MCAPTURE) */
	FRAME_READY,		/* Ready to start grabbing */
	FRAME_GRABBING,		/* In the process of being grabbed into */
	FRAME_DONE,			/* Finished grabbing, but not been synced yet */
	FRAME_ERROR,		/* Something bad happened while processing */
};

struct se401_regvals {
	enum {
	  SE401_DONE_BUS,
	  SE401_REG_BUS,
	  SE401_I2C_BUS,
	} bus;
	unsigned char reg;
	unsigned char val;
};

struct se401_frame {
	char *data;		/* Frame buffer */

	int depth;		/* Bytes per pixel */
	int width;		/* Width application is expecting */
	int height;		/* Height */

	int hdrwidth;		/* Width the frame actually is */
	int hdrheight;		/* Height */

	int sub_flag;		/* Sub-capture mode for this frame? */
	int format;		/* Format for this frame */
	int segsize;		/* How big is each segment from the camera? */

	volatile int grabstate;	/* State of grabbing */
	int scanstate;		/* State of scanning */

	int curline;		/* Line of frame we're working on */
	int curpix;
	int segment;		/* Segment from the incoming data */

	long scanlength;	/* uncompressed, raw data length of frame */
	long bytes_read;	/* amount of scanlength that has been read from *data */

	wait_queue_head_t wq;	/* Processes waiting */
};

#define SE401_NUMFRAMES	2
#define SE401_NUMSBUF	2

struct usb_se401 {
	struct video_device vdev;
	
	/* Device structure */
	struct usb_device *dev;

	char *camera_name;
//	unsigned char customid; /* Type of camera */

	unsigned char iface;
	
	struct semaphore lock;
	int user;			/* user count for exclusive use */

	int streaming;		/* Are we streaming Isochronous? */
	int grabbing;		/* Are we grabbing? */

	int compress;		/* Should the next frame be compressed? */

	char *fbuf;			/* Videodev buffer area */

	int sub_flag;		/* Pix Array subcapture on flag */
	int subx;		/* Pix Array subcapture x offset */
	int suby;		/* Pix Array subcapture y offset */
	int subw;		/* Pix Array subcapture width */
	int subh;		/* Pix Array subcapture height */

	int curframe;		/* Current receiving sbuf */
	struct se401_frame frame[SE401_NUMFRAMES];	

	int cursbuf;		/* Current receiving sbuf */
	struct se401_sbuf sbuf[SE401_NUMSBUF];

	/* Scratch space from the Isochronous pipe */
	unsigned char scratch[SCRATCH_BUF_SIZE];
	int scratchlen;

	wait_queue_head_t wq;	/* Processes waiting */
};

#endif

