/* 

   Dumping routing table structure 
   
   (c) 2001 HeeChul Yun (hcyun@etri.re.kr)

*/ 
#include <fcntl.h>

#include "pirq_routing.h"

#define PIRQ_SIGNATURE	(('$' << 0) + ('P' << 8) + ('I' << 16) + ('R' << 24))

void read_rt(unsigned char *rtbin )
{
  int i, j, entries;
  int len = 0;
  struct irq_routing_table *rt;
  struct irq_info *irqinfo;
  short tblsize;
  
  rt = (struct irq_routing_table *)rtbin;

  tblsize = *(short *)(rtbin + 6);
  if ( tblsize == 0 ) {
    len += printf("No irq_routing_table found. \n");
    len += printf("Try to boot with kernel parameter \"pci=biosirq\" .\n");     
    return; 
  }
  
  printf(">>> dump irq routing table of size=%d <<< \n", tblsize);

  printf("struct irq_routing_table intel_irq_routing_table = { \n");
  printf("0x%x,\t/* u32 signature */\n", rt->signature);
  printf("0x%x,\t/* u16 version */\n", rt->version);
  printf("%d,  \t/* u16 size */\n", rt->size);
  printf("0x%x,\t/*  u8 rtr_bus   - router bus */\n", rt->rtr_bus);
  printf("0x%x,\t/*  u8 rtr_devfn      - router devfn */\n", rt->rtr_devfn);
  printf("0x%x,\t/* u16 exclusive_irqs - mask of IRQs for PCI use */\n", rt->exclusive_irqs);
  printf("0x%x,\t/* u16 rtr_vendor     - router vendor id */\n", rt->rtr_vendor);
  printf("0x%x,\t/* u16 rtr_devfn      - router device id */\n", rt->rtr_device);	    
  printf("%d,  \t/*  u8 miniport_data  - crap */\n", rt->miniport_data);
  printf("{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* u8 rfu[11] */ \n");
  printf("%d, \t/*  u8 checksum. sum of all bytes mod 256 must be 0
 */\n", rt->checksum);
  printf("{\n");
  printf("  /* for each slot.. */ \n");

  entries = (rt->size - sizeof(struct irq_routing_table)) / sizeof(struct irq_info);
  irqinfo = rt->slots; 
  for ( i = 0; i < entries; i++, irqinfo++ ) {
    printf("  { /* slot %d */ \n", i); /* slot */ 
    printf("    0x%x, \t/*  u8 bus */\n", irqinfo->bus);
    printf("    0x%x, \t/* u16 devfn */\n", irqinfo->devfn);
    printf("    {\n"); /* irqs */ 
    for ( j = 0; j < 4; j++ ) {
      printf("      {\n ");
      printf("        0x%x, \t/* link */ \n", irqinfo->irq[j].link);
      printf("        0x%x, \t/* bitmap */ \n", irqinfo->irq[j].bitmap);
      printf("      },\n");
    } 
    printf("    }, \n"); /* irqs */ 
    printf("    0x%x, \t/* slot */\n", irqinfo->slot);
    printf("    0x%x, \t/* rfu */\n", irqinfo->rfu);
    printf("  }, \n"); /* slot */ 	  
  }
  printf("}\n");
  printf("}; /* end of irq routing table */ \n");
}


void usage()
{
  printf("Usage: $ parse_rt <bios map file>\n"); 
}

int main(int argc, char *argv[])
{
  int fd;
  int i, dword;
  unsigned char buf[64*1024];
  
  if ( argc != 2 ) {
    usage();
    exit(-1);
  }
  
  fd = open(argv[1], O_RDONLY);
  if ( ! fd ) {
    perror("file is not correct..");
    exit(-2); 
  }
  if ( read(fd, buf, 64 * 1024) != 64 * 1024 ) {
    perror("not 64kbyte..");
    exit(-3);
  }
  close(fd);
	     
  for ( i = 0; buf && i < 64*1024; i+=16 ){
    //printf("cnt=%d, dword=0x%x\n", cnt, dword);
    if ( *((unsigned int *)(buf + i))  == PIRQ_SIGNATURE ) { 
      printf("matchated at offset %d\n", i);
      read_rt(buf + i); 
    }	
  }
  
  return 0; 
}




