NOTIFY=0
xsetwacom --list devices|while read i
do
  if [ `echo $i|sed -e 's/.* type: \(.*\)/\1/g'` != 'PAD' ]
  then
    ID=`echo $i|sed -e 's/.* id: \([0-9]\?[0-9]\).*/\1/g'`
    if [ `xsetwacom get $ID mode` == 'off' ]
    then
      xsetwacom set $ID mode on
      NOTIFY=1
    else
      xsetwacom set $ID mode off
      NOTIFY=1
    fi
  fi
done
if [ $NOTIFY -eq $NOTIFY ]
then
  # texts have been kept short to prevent line breaking
  TITLE="Tablet configuration"
  MESSAGE="Toggled absolute/relative mode"
  ICON=gnome-display-properties.png
  if [ `which notify-send` != '' ]
  then
    notify-send -i $PWD/$ICON "$TITLE" "$MESSAGE"
  else
    if [ `which zenity` != '' ]
    then
      zenity --info --title "$TITLE" --text "$MESSAGE" --timeout=10
    else
      echo "$TITLE: $MESSAGE"
    fi
  fi
fi
