NOTIFY=0
xsetwacom --list devices|while read i
do
  ID=`echo $i|sed -e 's/.* id: \([0-9]\?[0-9]\).*/\1/g'`
  if [ `xsetwacom get $ID rotate` == 'none' ]
  then
    xsetwacom set $ID rotate half
    NOTIFY=1
  else
    if [ `xsetwacom get $ID rotate` == 'half' ]
    then
      xsetwacom set $ID rotate none
      NOTIFY=1
    else
      if [ `xsetwacom get $ID rotate` == 'cw' ]
      then
        xsetwacom set $ID rotate ccw
        NOTIFY=1
      else
        if [ `xsetwacom get $ID rotate` == 'ccw' ]
        then
          xsetwacom set $ID rotate cw
          NOTIFY=1
        fi
      fi
    fi
  fi
done
if [ $NOTIFY -eq $NOTIFY ]
then
  # texts have been kept short to prevent line breaking
  TITLE="Tablet configuration"
  MESSAGE="Rotated orientation"
  ICON=rotate.png
  if [ `which notify-send` != '' ]
  then
    notify-send -i $PWD/$ICON "$TITLE" "$MESSAGE"
  else
    if [ `which zenity` != '' ]
    then
      zenity --info --title "$TITLE" --text "$MESSAGE" --timeout=10
    else
      echo "$TITLE: $MESSAGE"
    fi
  fi
fi
