NOTIFY=0
xsetwacom --list devices|while read i
do
  if [ `echo $i|sed -e 's/.* type: \(.*\)/\1/g'` == 'TOUCH' -o `echo $i|sed -e 's/.* type: \(.*\)/\1/g'` == 'PAD' ]
  then
    ID=`echo $i|sed -e 's/.* id: \([0-9]\?[0-9]\).*/\1/g'`
    if [ `xsetwacom get $ID touch` == 'off' ]
    then
      xsetwacom set $ID touch on
      NOTIFY=1
    else
      xsetwacom set $ID touch off
      NOTIFY=1
    fi
    if [ `xsetwacom get $ID gesture` == 'off' ]
    then
      xsetwacom set $ID gesture on
      NOTIFY=1
    else
      xsetwacom set $ID gesture off
      NOTIFY=1
    fi
  fi
done
if [ $NOTIFY -eq $NOTIFY ]
then
  # texts have been kept short to prevent line breaking
  TITLE="Tablet configuration"
  MESSAGE="Toggled touch and gesture support"
  ICON=gnome-session-switch.png
  if [ `which notify-send` != '' ]
  then
    notify-send -i $PWD/$ICON "$TITLE" "$MESSAGE"
  else
    if [ `which zenity` != '' ]
    then
      zenity --info --title "$TITLE" --text "$MESSAGE" --timeout=10
    else
      echo "$TITLE: $MESSAGE"
    fi
  fi
fi
