/*
 * Created: 10-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver;

import java.net.Socket;

import org.apache.log4j.Logger;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

/**
 * Handles one client connection.  On construction it receives 
 * the accepted socket to the client and an <code>EventParser</code>
 * that knows how to construct <code>LoggingEvents</code> out of 
 * the incoming byte stream.
 * 
 * A <code>ClientHandler</code> is created by a <code>LogServerRunnable</code>
 * in response to a client connection.
 *   
 * @author swoodward
 */
public class ClientHandler implements Runnable
{

  ClientHandler(Socket socket, EventParser parser, LoggerRepository hierarchy)
  {
    this.socket = socket;
    this.parser = parser;
    this.hierarchy = hierarchy;  
  }

  /* (non-Javadoc)
   * @see java.lang.Runnable#run()
   */
  public void run()
  {
    LoggingEvent event;
    Logger remoteLogger;

    try
    {
      while (true)
      {
        if (Thread.currentThread().isInterrupted())
        {
          logger.info("ClientHandler interrupted.");
          break;
        }
        // read an event from the wire
        event = parser.parseEvent();
        // get a logger from the hierarchy. The name of the logger is taken to be the name contained in the event.
        if (event == null)
        {
          logger.error("ClientHandler recieved null event from parser - exiting.");
          break;
        }
        remoteLogger = hierarchy.getLogger(event.getLoggerName());
        //event.logger = remoteLogger;
        // apply the logger-level filter
        if (event.getLevel().isGreaterOrEqual(remoteLogger.getEffectiveLevel()))
        {
          // finally log the event as if was generated locally
          remoteLogger.callAppenders(event);
        }
      }
    }
    catch (Exception e)
    {
      logger.error("Unexpected exception. Closing connection.", e);
    }
    
    logger.info("Client handler exiting.");
    try
    {
      socket.close();
    }
    catch (Exception e)
    {
      logger.info("Could not close connection.", e);
    }
  }

  private Socket socket;
  private EventParser parser;
  private LoggerRepository hierarchy;
  static Logger logger = Logger.getLogger(SocketNode.class);
}