/*
 * Created: 10-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver;

import java.io.InputStream;

import org.apache.log4j.spi.LoggingEvent;

/**
 * Base class for event parsers that know how to parse a <code>LoggingEvent</code>
 * out of a binary stream.  Each LogServerRunnable owns an <code>EventParser</code>
 * which it passes to each spawned <code>ClientHandler</code>.
 * 
 * @author swoodward
 */
public abstract class EventParser
{
  public void setInputStream(InputStream strm)
  {
    this.strm = strm;
  }

  public abstract LoggingEvent parseEvent();
  protected InputStream strm;
}
