package com.peregrine.discovery.logserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

/** 
 Extend DataInputStream to provide methods to read little endian
 numerical values
 */

public class LittleEndianDataInputStream extends DataInputStream
{
  public LittleEndianDataInputStream(InputStream in)
  {
    super(in);
    buff = new byte[8];
  }

  public final char readLEChar() throws IOException
  {
    readFully(buff, 0, 2);
    return (char) ((buff[1] & 0xff) << 8 | (buff[0] & 0xff));
  }

  public final double readLEDouble() throws IOException
  {
    return Double.longBitsToDouble(readLELong());
  }

  public final float readLEFloat() throws IOException
  {
    return Float.intBitsToFloat(readLEInt());
  }

  public final int readLEInt() throws IOException
  {
    readFully(buff, 0, 4);
    return (buff[3]) << 24 | 
      (buff[2] & 0xff) << 16 | 
      (buff[1] & 0xff) << 8  | 
      (buff[0] & 0xff);
  }

  public final long readLELong() throws IOException
  {
    readFully(buff, 0, 8);
    return (long) (buff[7]) << 56 | 
      (long) (buff[6] & 0xff) << 48 | 
      (long) (buff[5] & 0xff) << 40 | 
      (long) (buff[4] & 0xff) << 32 | 
      (long) (buff[3] & 0xff) << 24 | 
      (long) (buff[2] & 0xff) << 16 | 
      (long) (buff[1] & 0xff) << 8 | 
      (long) (buff[0] & 0xff);
  }

  public final short readShortLE() throws IOException
  {
    readFully(buff, 0, 2);
    return (short) ((buff[1] & 0xff) << 8 | (buff[0] & 0xff));
  }

  public final int readUnsignedShortLE() throws IOException
  {
    readFully(buff, 0, 2);
    return ((buff[1] & 0xff) << 8 | (buff[0] & 0xff));
  }

  // Use one buffer for performance reasons - not multithread-safe
  private byte buff[];
}

