/*
 * Created: 12-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author swoodward
 */
public class Log4CxxStreamParser extends EventParser
{
  public Log4CxxStreamParser()
  {
    cat.debug("Creating Log4CxxStreamParser");
  }

  public LoggingEvent parseEvent()
  {
    if (first)
      first = false;
    else
      NDC.pop(); // Pop the NDC pushed by the previous item
    
    try
    {
      String fqnCategory = readString();
      String loggerName = readString();
      Level level = readLevel();
      String message = readString();
      long timeStamp = readLong();
      String file = readString();
      cat.debug("Read file: " + file);
      int line = readInt();
      cat.debug("Read line: " + String.valueOf(line));
      String ndc = readString();
      cat.debug("Read ndc: " + ndc);
      readMDC();
      readProps(); // Properties
      String threadId = Integer.toString(readInt());

      NDC.push(ndc);
      if (!Thread.currentThread().getName().equals(threadId)) 
        Thread.currentThread().setName(threadId);
      return new LoggingEvent(fqnCategory, Logger.getLogger(loggerName),
          timeStamp, level, message, null);
    }
    catch (IOException e)
    {
      cat.error("Exception parsing logging event:" + e);
      return null;
    }
  }

  public void setInputStream(InputStream strm)
  {
    super.setInputStream(strm);
    dataStrm = new LittleEndianDataInputStream(strm);
  }

  protected String readString() throws IOException
  {
    // Pascal-style string, but with 4 byte size
    int size = dataStrm.readLEInt();
    byte[] str = new byte[size];

    int i = 0;
    while (i < size)
    {
      str[i] = dataStrm.readByte();
      i++;
    }

    cat.debug(MessageFormat.format("Read string: \"{0}\"",
        new Object[] { new String(str) }));
    return new String(str);
  }

  protected int readInt() throws IOException
  {
    return dataStrm.readLEInt();
  }

  protected long readLong() throws IOException
  {
    long ret = dataStrm.readLELong();
    cat.debug(MessageFormat.format("Read long: {0}", new Object[] { new Long(
        ret) }));
    return ret;
  }

  protected Level readLevel() throws IOException
  {
    int intLevel = readInt();
    String strLevel = readString();
    cat.debug(MessageFormat.format("Read integer level of {0}.\n"
        + "read string level of {1}.", new Object[] { new Integer(intLevel),
        strLevel }));
    
    cat.debug(MessageFormat.format("Level translates to \"{0}\".",
        new Object[] { Level.toLevel(intLevel, Level.INFO).toString() }));

    return Level.toLevel(intLevel, Level.INFO);
  }
  
  protected void readMDC() throws IOException
  {
    cat.debug("Reading MDC");
    readProps();
  }
  
  protected Properties readProps() throws IOException
  {
    Properties ret = new Properties();
    int size = readInt();
    for (int i = 0; i < size; i++)
      ret.setProperty(readString(), readString());
    cat.debug("Read props: " + ret);
    return ret;
  }

  protected static Logger cat = Logger.getLogger(Log4CxxStreamParser.class);

  OutputStream dumper = null;
  LittleEndianDataInputStream dataStrm;
  boolean first = true;
}