/*
 * Created: 10-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

class InitException extends Exception
{
  public InitException(Exception base)
  {
    super(base);
  }
  
  private static final long serialVersionUID = 1L;
}

/**
 * @author swoodward
 * 
 * LogServer is the main class for our little log server.  It reads a 
 * properties file for the configuration of the server threads and a 
 * properties or XML Log4J file for the logging config.
 * 
 * For the server configuration properties format, see {@link #init(String, String) init}
 * for details.  
 */
public class LogServer
{
  public static void main(String argv[])
  {
    if (argv.length == 2)
    {
      try
      {
        init(argv[0], argv[1]);
      }
      catch (InitException e)
      {
        System.out.println(e);
        System.out.println(e.getStackTrace());
        return;
      }
    }
    else
    {
      usage("Wrong number of arguments.");
      return;
    }
/*
    try
    {
      while (true)
      {
        cat.info("Waiting to accept a new client.");
        Socket socket = serverSocket.accept();
        cat.info("Connected to client at " + socket.getInetAddress());
        cat.info("Starting new socket node.");
        new Thread(new SocketNode(socket, LogManager.getLoggerRepository())).start();
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }*/
  }

  static void usage(String msg)
  {
    System.err.println(msg);
    System.err.println("Usage: java " + LogServer.class.getName()
        + " LogConfigFile ServerConfigFile");
  }

  /**
   * Initialise the LogServer from two configuration files.
   * 
   * The server is configured by use of a configuration properties file.  
   * An example to configure 2 server threads, one for Cxx streams and one
   * for java streams is below.  To add a new server thread, add a new section
   * with a unique number in <code>logserver.serverthread.[Uniq].XXX.  Each
   * section needs the following properties:
   * <ul>
   * <li>parserclass</li>
   * <li>port</li>
   * </ul>
   * <code>
   * logserver.serverthread.1.parserclass=CxxStreamParser
   * logserver.serverthread.1.port=8111
   * logserver.serverthread.2.parserclass=JavaStreamParser
   * logserver.serverthread.2.port=8112 
   * </code>
   * 
   * @param logConfigFile the main server configuration file.  See above 
   *        for format details.
   * @param serverConfigFile the configuration of the log4j logging  
   * @author swoodward
   */
  static void init(String logConfigFile, String serverConfigFile) throws InitException
  {
    if (logConfigFile.endsWith(".xml"))
    {
      DOMConfigurator.configure(logConfigFile);
    }
    else
    {
      PropertyConfigurator.configure(logConfigFile);
    }

    Properties config = new Properties();
    try
    {
      config.load(new BufferedInputStream(new FileInputStream(serverConfigFile)));
      Configurator.configure(config);
    }
    catch (FileNotFoundException e)
    {
      throw new InitException(e);
    }
    catch (IOException e)
    {
      throw new InitException(e);
    }
    catch (InstantiationException e)
    {
      throw new InitException(e);
    }
    catch (IllegalAccessException e)
    {
      throw new InitException(e);
    }
  }
  
  protected static Logger cat = Logger.getLogger(LogServer.class);
}

