/*
 * Created: 11-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author swoodward
 */
public class ObjectStreamParser extends EventParser
{

  public void setInputStream(InputStream strm)
  {
    super.setInputStream(strm);
    
    try
    {
      ois = new ObjectInputStream(new BufferedInputStream(strm));
    }
    catch (Exception e)
    {
      logger.error("Could not open ObjectInputStream to " + strm, e);
    }    
  }
  
  /* (non-Javadoc)
   * @see com.peregrine.discovery.logserver.EventParser#parseEvent(java.io.InputStream)
   */
  public LoggingEvent parseEvent()
  {
    if (ois == null)
      return null;
      
    try
    {
      return (LoggingEvent) ois.readObject();
    }
    catch (IOException e)
    {
      logger.error("Could not read event.", e);
    }
    catch (ClassNotFoundException e)
    {
      logger.error("Unexpected object type.", e);
    }
    return null;
  }

  static Logger logger = Logger.getLogger(ObjectStreamParser.class);
  ObjectInputStream ois;
}