/*
 * Created: 12-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver.tests;

import java.io.FileInputStream;
import java.io.IOException;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

import com.peregrine.discovery.logserver.Log4CxxStreamParser;

/**
 * @author swoodward
 */
public class Log4CxxStreamTest extends TestCase
{
  public void testParseEvent() throws IOException
  {
    BasicConfigurator.configure();
    FileInputStream instrm = new FileInputStream(getClass().getResource(
        "cxxstream.bin").getFile());
    
    Log4CxxStreamParser prsr = new Log4CxxStreamParser();
    prsr.setInputStream(instrm);
    
    LoggingEvent event = prsr.parseEvent();
    assertEquals(Level.DEBUG, event.getLevel());
    event = prsr.parseEvent();
    assertEquals(Level.INFO, event.getLevel());
    event = prsr.parseEvent();
    assertEquals(Level.WARN, event.getLevel());
    event = prsr.parseEvent();
    assertEquals(Level.ERROR, event.getLevel());
    event = prsr.parseEvent();
    assertEquals(Level.FATAL, event.getLevel());
    assertTrue(instrm.available() == 0);
  }
}