/*
 * Created: 11-Jan-2005
 * Author : swoodward
 */
package com.peregrine.discovery.logserver.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import junit.framework.TestCase;

import com.peregrine.discovery.logserver.EventParser;
import com.peregrine.discovery.logserver.LogServerRunnable;

class PublicLogServerRunnable extends LogServerRunnable
{
  public PublicLogServerRunnable(int port, Class eventParserClass,
      Properties parserProps)
  {
    super(port, eventParserClass, parserProps);
  }

  public static EventParser createParser(Class eventParserClass,
      Properties parserProps, InputStream strm)
  {
    return LogServerRunnable.createParser(eventParserClass, parserProps, strm);
  }
}

/**
 * @author swoodward
 */
public class LogServerRunnableTest extends TestCase
{
  public void testCreateParser() throws IOException
  {
    Properties props = new Properties();
    
    props.load(new ByteArrayInputStream(new String(
        "propA=test value\n" +
        "propB=test value 2\n"
        ).getBytes()));
    
    InputStream strm = new ByteArrayInputStream(new String("gboo").getBytes());    
    TestParser parser = (TestParser)PublicLogServerRunnable.createParser(TestParser.class, props, strm);
    assertEquals("test value", parser.getPropA());
    assertEquals("test value 2", parser.getPropB());
  }
}
