#!/bin/sh
# Copyleft (c) 2003 by Knut Stormkartr (Stormbringer Systems)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# MCQUILLAN SYSTEMS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
# OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# 2004-04-15 -- install a few local applications - Knut Stormkartr
#
##############################################################################

ltsp_xmms()
{

    XMMS=`which xmms`;
    if  [ $XMMS ]
      echo "found XMMS at: " $XMMS
      echo "copying required files into /opt/ltsp/i386/"
      cp -i /usr/bin/unzip /opt/ltsp/i386/usr/bin
      mkdir /opt/ltsp/i386/usr/share/xmms
      mkdir /opt/ltsp/i386/usr/share/xmms/Skins
      cp -ipd $XMMS /opt/ltsp/i386/$XMMS
      cp -ipd /usr/lib/libxmms* /opt/ltsp/i386/usr/lib
      cp -iRpd /usr/lib/xmms /opt/ltsp/i386/usr/lib
      cp -iRpd /usr/lib/libasound* /opt/ltsp/i386/usr/lib
      cp -iRpd /usr/lib/libmikmod* /opt/ltsp/i386/usr/lib
      cp -iRpd /usr/lib/libvorbis* /opt/ltsp/i386/usr/lib
      cp -iRpd /usr/lib/libogg* /opt/ltsp/i386/usr/lib
      cp ltsp-xmms.sh /usr/local/bin
      echo "All done. You should now be able to run: /usr/local/bin/ltsp-xmms.sh"
      echo "Press a key. . ." ; 
      read ;
      return;
   then 
      echo "can not find XMMS on your system."
      echo "are you sure it is installed?."
     echo "Press a key. . ." ; 
     read ;
    fi
}  

ltsp_ayttm()
{

    AYTTM=`which ayttm`;
    if  [ $AYTTM ]
      echo $AYTTM
      cp /usr/lib/libgpg* /opt/ltsp/i386/usr/lib
      cp /bin/netstat /opt/ltsp/i386/usr/bin
      cp -Ripd /usr/lib/ayttm /opt/ltsp/i386/usr/lib
      cp $AYTTM /opt/ltsp/i386/usr/bin
      cp ltsp-ayttm.sh /usr/local/bin
      echo "All done. You should now be able to run: /usr/local/bin/ltsp-ayttm.sh"
      echo "Press a key. . ." ; 
      read ;
      return;
    then
      echo "can not find AyTTM on your system."
      echo "are you sure it is installed?."
      echo "Press a key. . ." ; 
      read ;
    fi

}  

ltsp_xboard()
{

    XBOARD=`which xboard`;
    if  [ $XBOARD ]
      echo $XBOARD
      cp $XBOARD /opt/ltsp/i386/usr/bin
      cp ltsp-xboard.sh /usr/local/bin
      cp ltsp-xboard-fics.sh /usr/local/bin
      echo "All done. "
      echo "You should now be able to run: /usr/local/bin/ltsp-xboard.sh"
      echo " or for the preconfigured FICS script: /usr/local/bin/ltsp-xboard-fics.sh"
      echo "Press a key. . ." ; 
      read ;
      return;
    then
      echo "can not find xboard on your system."
      echo "are you sure it is installed?."
      echo "Press a key. . ." ; 
      read ;
    fi

}  

common_libs()
{
      cp -ipd /usr/lib/libstdc++* /opt/ltsp/i386/usr/lib
      cp -ipd /usr/lib/libgtk-1.2* /opt/ltsp/i386/usr/lib
      cp -ipd /usr/lib/libgdk-1.2* /opt/ltsp/i386/usr/lib
      cp -ipd /usr/lib/libgmodule-1.2* /opt/ltsp/i386/usr/lib
      cp -ipd /usr/lib/libgthread-1.2* /opt/ltsp/i386/usr/lib      
      cp -ipd /usr/lib/libglib-1.2* /opt/ltsp/i386/usr/lib
      cp -ipd /lib/libm* /opt/ltsp/i386/lib
      cp -ipd /lib/libc* /opt/ltsp/i386/lib
      cp -ipd /usr/lib/libgdk_pixbuf* /opt/ltsp/i386/usr/lib
      cp -ipd /lib/libcrypt* /opt/ltsp/i386/lib
      cp -ipd /lib/libssl* /opt/ltsp/i386/lib
      cp -ipd /usr/lib/libltdl* /opt/ltsp/i386/usr/lib
      cp -i /usr/lib/lib*spell* /opt/ltsp/i386/usr/lib
      
}
username=`id -nu`              # Or...   username=`whoami`
if [ "$username" = "root" ]
then
  echo "You did make a BACKUP just in case";
  echo "right!?";
 while :
        do
           clear
           echo "-------------------------------------"
           echo " Main Menu "
           echo "-------------------------------------"
           echo "[1] Copy common libaries (DO THIS FIRST!)"
           echo "[2] Add XMMS as local app"
           echo "[3] Add AyTTM as local app"
           echo "[4] Add xboard as local app"
           echo "[5] Do it ALL!"
           echo "[0] Exit/Stop"
           echo "======================="
           echo -n "Enter your menu choice [0 - 5]: "
           read yourch
           case $yourch in
                  1) common_libs;;
                  2) ltsp_xmms;;
                  3) ltsp_ayttm;;
                  4) ltsp_xboard;;
                  5) common_libs; ltsp_xmms; ltsp_ayttm; ltsp_xboard;;
                  0) exit 0 ;;
                  *) echo "Please select choice 0,1,2,3,4 or 5";
                  echo "Press a key. . ." ; read ;;
           esac
  done

else
  echo "$username, "
  echo "You must be root to use this script "
  echo "otherwise you get nothing.             "
  exit 1;
fi

