#! /bin/bash

. ./config.sh
. tools/functions.sh

mkdir $mm_conf_dir

for i in $list_opts_dir/*.conf; do
    listname=`echo $i | sed -n 's/.*\/\(.*\)\.conf/\1/p'`
    pwd=`grep ^PW= $i | cut -d'=' -f2 `

    echo "******** list $i *********"

    first=1
    
    # cycle through every element in the line of owners separated by comma
    # maybe contains owner names in parantheses
    # may not be 
    
    for possible_admin in `grep "Owner=" $i | \
        sed 's/Owner=//g' | \
	sed 's/^[[:space:]]*//g' | \
	sed 's/[[:space:]].*//g' | \
	sed 's/[\(].*[\)]//g' | \
        gawk -F\, '{for(i=1;i<=NF;i++){ print $i } }'`; do

	#echo "possible owner: $possible_admin"
	admin=`tools/validate_email.sh $possible_admin`

	if [ "_$admin" ==  "_" ]; then 
		echo "Error: not valid email: $possible_admin"; # does not fit to the patter something@host.domain
		continue;
	fi

	#echo "adding owner: $admin"

        if [ $first -gt 0 ] ; then
	    first=0
	    str="newlist -q -l hu $listname $admin $pwd"
	    prev_admin=$admin;
	else
	    str="clone_member -q -l $listname -a $prev_admin $admin"
	fi
        exec_str

    done
    # to get the list owners know the new password of list
    # do it in "non-quiet" mode of change_pw !!!!
    str="change_pw -p $pwd -l `echo "$listname" |tr '[A-Z]' '[a-z]'` " # -q
    exec_str

    _listname=`echo $listname | tr 'A-Z' 'a-z'`
    cat doc/LISTSERV_DEFAULT.mm > $mm_conf_dir/$listname.mm
    str="tools/conf_convert.py $i >> $mm_conf_dir/$listname.mm"
    exec_str
    str="config_list -i $mm_conf_dir/$listname.mm $_listname"
    exec_str
done

if [ $leave_files -eq 0 ]; then
    rm -Rf $list_opts_dir
fi
