#!/bin/bash

. ./config.sh
. tools/functions.sh
ls $received_mails_dir > file_list
rm *.opts -f

mkdir $digest_mails_dir
rm $digest_mails_dir/* -f

# Cycle through every file in mails directory
# that ends with swszl

for file_id in `cat file_list | grep \.swszl`; do
    # Get the line that begins with "Subscription options for"
    # and parse list name and user name from it
    
    query_list=`grep ^\>\ query  $received_mails_dir/$file_id`
    list=`echo $query_list | cut -d' ' -f3`
    possible_user=`echo $query_list | cut -d' ' -f5`
    
    user=`tools/validate_email.sh $possible_user`

    if [ "_$user" ==  "_" ]; then 
        echo "Error: not valid email: $possible_user in list $list"; # does not fit to the patter something@host.domain
        continue;
    fi

    filename="$list.$user.opts"
    #echo "file $file_id, list: $list, $user"

    # Get the options as the first column of the file from mail
    # in which secion "Return-Path .... Subscrition options"
    # and "Subscription date ... Job origin" is excluded
    # just likes lines begining space or containing ":"
    
    options=`cat $received_mails_dir/$file_id | \
    sed /Return\-Path/,/^Subscription\ options\ for/d | \
    sed /^Subscription\ date/,/\^\ Job\ origin\:/d | \
    grep -v \: | \
    grep -v ^\  | \
    awk '{print $1}'`
    #echo "options: $options"
    
    # if DIGEST is included in the options, then append the user the
    # nondig_... or digest_... file
    
    digest=`echo $options | grep DIGEST`
    if [ "_$digest" == "_" ]; then
    	echo "echo $user >> $digest_mails_dir/nondig_$list"
        echo $user >> $digest_mails_dir/nondig_$list
    else
    	echo "echo $user >> $digest_mails_dir/digest_$list"
        echo $user >> $digest_mails_dir/digest_$list
    fi
done
# Add digest members to list
for dig_list in $digest_mails_dir/digest_*; do
    list=`echo $dig_list | sed "s/$digest_mails_dir\/digest_//g"` 
    str="add_members -d $dig_list -w n $list"
    exec_str;
done

# Add nondigest members to list
for nondig_list in $digest_mails_dir/nondig_*; do
    list=`echo $nondig_list | sed "s/$digest_mails_dir\/nondig_//g"` 
    str="add_members -r $nondig_list -w n $list"
    exec_str
done

# clean intermediate files

if [ $leave_files -eq 0 ]; then
    rm -f file_list
    rm -Rf $digest_mails_dir
fi
