# This is MAIN directory of Listserv. 
# This is where it stores list config files (*.LIST)
export listserv_dir=MAIN

# LIST files of Listserv in the directory above are "half binary" files.
# The first 11 bytes represent a listserv fingerprint
# after that each 100 bytes correspond to a row.
# The result of this conversion is put in the following directory
export mid_dir=mid

# Options for the lists are generated in this directory from the ".LIST" file
list_opts_dir=list_opts

# List members are generated in this directory from the ".LIST" file
export members_dir=list_members

# User's options are collected by sending an email to listserv@listerv.nowhere.edu
# The email address of the listserv is
export listserv_email=listserv@listserv.iif.hu

# One administrtor of Listserv for which email box you have access to.
# Note that! You will receive one mail per user in this box!
export admin_email=admin@listserv.nowhere.edu

# All received mails coming as a response to our request should be placed
# in this directory
export received_mails_dir=mails

# Digest and non digest lists are generated in mailman in a bulk mode.
# For this reason we collect digest and non digest mails separately 
# in this directory
export digest_mails_dir=digest_mails

# Mailman config files are collected in this directory
export mm_conf_dir=mm_conf

# For debugging purposes you may want to keep intermediat files and not
# to delete them after use.
export leave_files=1

# For debugging purposes. If this quiet flag is set, then nothing is done,
# but everything that would be done is echo-ed.
export quiet=0

# Since debian do not link change_pw to be accessible from PATH
# please give MAILMAN_PATH
export MAILMAN_PATH=/usr/lib/mailman/bin

export PATH=$PATH:$MAILMAN_PATH

