#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

int main()
{
	enum { def, parenth, comma, comma_parenth } state_m; // state machine
	enum { copy, del } def_out_op; // default output operation

	if (feof(stdin))
	{
		fprintf(stderr,"Usage:\n");
		fprintf(stderr,"Program returns a string converted from the standard input.\n");
		fprintf(stderr,"From this all expressions that are enclosed in parenthesis are dropped,\n");
		fprintf(stderr,"but not those that that are preceded by a comma.\n");
		exit(-1);
	}

	state_m = def;
	def_out_op  = copy;

	char c;
	for(c=fgetc(stdin); !feof(stdin); c=fgetc(stdin) )
	{
		//char c = str[i];
		switch( state_m )
		{
		  case def:  // ========================= default state
			switch( c )
			{
			  case '(':
				def_out_op = del;
				state_m    = parenth;
				continue; // eat this character
				
			  case ',':
				def_out_op = copy;
				state_m    = comma;
				break;
			}
			break;
			
		  case parenth:  // ========================== parenthesis state 
			if ( c == ')' )
			{
				def_out_op = copy;
				state_m    = def;
				continue; // eat this character
			}
			break;
			
		  case comma:   // ========================== comma state
			if ( c == '(' )
			{
				def_out_op = copy;
				state_m    = comma_parenth;
			}
			
			if ( !isspace( c ) && c != '(' )
			{
				def_out_op = copy;
				state_m    = def;
			}
			break;
		  case comma_parenth:
			if ( c == ')' )
			{
				def_out_op = copy;
				state_m    = def;
			}
			break;
		  default:
			fprintf(stderr,"Error in state machine operation");
			exit(1);
		}
		if (def_out_op == copy)
			fputc(c,stdout);
	}
}
