<?php
# # #
# XML Parser Class which is able to read any xml file and writing the
# elements and there entities into an array
#

class xml_mm
// 
{

	function __construct($xml_file_id="")
	{
		if (!is_file($xml_file_id)) {
			$xml = self::get_xml_file($xml_file_id);
		}
	   
		if (!isset($this -> error_message)) {
			self::read_xml_file($xml_file_id);
			if (is_array($this -> elements)) {
				self::push_result();
			}
		}
	}
	
	private function push_result()
	{

		$root_node = key($this -> elements);
		if (is_array(pos($this -> elements))) {
			
			$this -> $root_node = pos($this -> elements);
		}
		unset($this -> elements);
	}
	
	private function get_xml_file($xml_file_id)
	// obtain informations about the file path
	{
		
		$query = "
			SELECT
				content_id,
				content_type,
				content_date
			FROM
				".$_SESSION['translation']."_index
			WHERE
				content_id = '".$xml_file_id."'
		";
		$result = mysql_query($query);
		if (list($doc_id, $doc_type, $doc_date) = @mysql_fetch_row($result)) {
			
			$this -> doc_id = $doc_id;
			$this -> doc_type = $doc_type;
			$this -> doc_date = $doc_date;
		
			$this -> dep = explode("-", substr($doc_date, 0, 10));
			
			$this -> xml_file_path  = MEDIA_PATH."/".$doc_type."/";
			$this -> xml_file_path .= $this -> dep['0']."/".$this -> dep['1']."/".$this -> dep['2']."/";
			$this -> xml_file_path .= $doc_id."/".$doc_id."_".$_SESSION['translation'].".xml";
			
			return $this -> xml_file_path;
		} else {
			
			$this->error_message = "file_not_found: ".$xml_file_id;
		}
	}
	
	public function read_xml_file ($xml_file, $url="")
	// Reads the content of an xml file and parses its entities
	{
	
		if (!file_exists($xml_file) and $url != "true")
		// Perform file existance check
		{
			// The Value of the error_message contains the language
			// pointer to the error message so the user is able to
			// read the message in the users native language
 			$this->error_message = "file_not_exists";
		} else {
			
			$xml_data = file_get_contents($xml_file);
			$xml_parser = xml_parser_create();
			xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, 0);
			xml_parser_set_option($xml_parser, XML_OPTION_SKIP_WHITE, 1);
			xml_parse_into_struct($xml_parser, $xml_data, $vals);
			if (is_array($vals) && DEBUG_MODE == 'on' && DEBUG_TYPE == 'xml_parser') {
				if (xml_error_string($xml_parser) != 'Unknown') {
					echo xml_error_string($xml_parser);
				}	
			}
			xml_parser_free($xml_parser);
			if (is_array($vals)) {
				$this -> elements = self::struct_to_array($vals);
			}
		}
	}
	
	function struct_to_array (&$xml_struct, &$pos="0")
	//
	{
		$result = array();
		if ($xml_struct[$pos]['type'] == 'open' || $xml_struct[$pos]['type'] == 'complete') {
			$tag = $xml_struct[$pos]['tag'];
			if ($xml_struct[$pos]['attributes']) {
				$result[$xml_struct[$pos]['tag']]['attribute'] = $xml_struct[$pos]['attributes'];
			}
			if ($xml_struct[$pos]['value']) {
				$result[$xml_struct[$pos]['tag']]['cdata'] = $xml_struct[$pos]['value'];
			}
			if ($xml_struct[$pos]['type'] == 'complete') {
				++$pos;
				return $result;
			}
			++$pos;
		}
		while ($pos < count($xml_struct) && $xml_struct[$pos]['type'] != 'close') {
			$parsed_stuff = self::struct_to_array($xml_struct, $pos);
			if (!$result[$tag][key($parsed_stuff)]) {
				$result[$tag][key($parsed_stuff)] = $parsed_stuff[key($parsed_stuff)];
			} elseif (!$result[$tag][key($parsed_stuff)][0]) {
				$temp = $result[$tag][key($parsed_stuff)];
				$result[$tag][key($parsed_stuff)] = array($temp,$parsed_stuff[key($parsed_stuff)]);
			} else {
				$result[$tag][key($parsed_stuff)][] = $parsed_stuff[key($parsed_stuff)];
			}
		}
		// close found
		++$pos;
		return $result;
	}
	
	private function trim_result($array_value)
	{
		if (is_array($array_value))
		{
			foreach($array_value AS $key => $value)
			{
				
				if (trim($value) != '')
				{
					$element_value = $value;
				}
			}			
		} else {
			
			$element_value = $array_value;
		}

		return $element_value;
	}
	
	public function ret_xml_data($xml_file_id)
	// while creating the object try to read an xml file directly
	{
		$this -> counter = 0;
		
		if (!file_exists($xml_file_id)) {
		
			$xml_file_id = self::get_xml_file($xml_file_id);
		}
		if (!isset($this -> error_message)) {
			
			self::read_xml_data($xml_file_id);
			if (is_array($this->element_names)) {
				
				self::push_result();
			}
		}
	}
	
	public function read_xml_data ($xml_file)
	// Reads the content of an xml file and parses its entities
	{
	
		if (!file_exists($xml_file))
		// Perform file existance check
		{
			// The Value of the error_message contains the language
			// pointer to the error message so the user is able to
			// read the message in the users native language
 			$this -> message = "file_not_exists";
 			$this -> message_type = "error";
		
		} else {
		
			// Read content of the given xml file as string into a variable
			$xml_data = file_get_contents($xml_file);
			
			// create xml parser and define the needed handlers
			$xml = xml_parser_create('UTF-8');
			xml_set_object($xml, &$this);
			xml_set_element_handler($xml, 'start_handler', 'end_handler');
			xml_set_character_data_handler($xml, 'character_handler');
			
			// Disable UPPERCASE conversion of element names
			xml_parser_set_option($xml, XML_OPTION_CASE_FOLDING, false);
			
			// parse xml file
			xml_parse($xml,$xml_data);
			xml_parser_free($xml);
				
		}
	}
	
	private function doc_path($params)
	{
		if ($params['doc_type'] == 'article') {
			$global_path = article_path;
		}
	
		$path_elements = explode("-", substr($params['doc_date'], 0, 10));
		$doc_path = $global_path.$path_elements['0']."/"
					.$path_elements['1']."/".$path_elements['2']."/"
					.$params['doc_id']."/";
					
		return $doc_path;
	}
	
	private function start_handler ($xml,$element,&$element_attributes)
	// Evaluates the name of an xml element and writes
	// its name into an array containing the elements
	// given in the xml file, the attributes are written
	// to an array based on the element names
	{
	
		$this->current_element = $element;
		$this->element_names[] = $this->current_element;
		$this->num_attributes = count($element_attributes);
		$this->keys = array_keys($element_attributes);
		for ($i = 0; $i < $this->num_attributes; $i++) {
			
			if ($this -> current_element == 'document_elements' || $this -> current_element == 'document_element_head' || $this -> current_element == 'zodiac') {
			
				$this->attribute[$this->current_element][strtolower($this->keys[$i])][] = $element_attributes[$this->keys[$i]];
			} else {
			
				$this->attribute[$this->current_element][strtolower($this->keys[$i])] = $element_attributes[$this->keys[$i]];
			}
		}
	}
	
	private function end_handler ($xml,$element)
	// Evaluates the name of the endtags of an xml element
	// and writes its name into an array containing the elements
	// given in the xml file
	{
	
		// Till now nothing happends to the end elements
	}
	
	private function character_handler ($xml, $data)
	// Function for writing the entity values into an array
	{
		if ($this -> current_element == 'document_elements' || $this -> current_element == 'document_element_head') {
			
			if ($this -> element_pointer != $this -> current_element) {
		
				$this->elements[$this -> current_element][] = $data;
			
				$this -> element_pointer = $this -> current_element;
			}
		} elseif (strlen(trim($data)) != '') {
				
			$this->elements[$this -> current_element][] = stripslashes($data);
		}
	}
}


# # #
#
#
?>
