/***********************************************************
 * YUVFPS with motion estimator for the mjpegtools         *
 * ------------------------------------------------------- *
 * (c) 2005, Jerome Cornet <jcornet@free.fr>               *
 *                                                         *
 * This was shamelessy inspired from the yuvdeinterlace    *
 * (C) 2001-2004 Stefan Fendt                              *
 * Thanks man, I took all the good things from you ;-)     *
 *                                                         *
 * Licensed and protected by the GNU-General-Public-       *
 * License version 2 or if you prefer any later version of *
 * that license). See the file LICENSE for detailed infor- *
 * mation.                                                 *
 *                                                         *
 * FILE: transform_block.c                                 *
 *                                                         *
 ***********************************************************/

#include "yuv4mpeg.h"
#include "transform_block.h"

extern int block_size;
void
transform_block (uint8_t * a1, uint8_t * a2, uint8_t * a3, int rowstride,
		 float percent)
{
  int x, y;

  for (y = 0; y < block_size; y++)
    {
      for (x = 0; x < block_size; x++)
	{
	  *(a1) = (uint8_t) ((float) *(a2) * percent + *(a3) * (1 - percent));
	  a1++;
	  a2++;
	  a3++;
	}
      /* process every line */
      a1 += rowstride - block_size;
      a2 += rowstride - block_size;
      a3 += rowstride - block_size;
    }
}

void
transform_block_chroma (uint8_t * a1, uint8_t * a2, uint8_t * a3,
			int rowstride, float percent)
{
  int x, y;

  for (y = 0; y < block_size / 2; y++)
    {
      for (x = 0; x < block_size / 2; x++)
	{
	  *(a1) = (uint8_t) ((float) *(a2) * percent + *(a3) * (1 - percent));
	  a1++;
	  a2++;
	  a3++;
	}
      /* process every second line */
      a1 += rowstride - block_size / 2;
      a2 += rowstride - block_size / 2;
      a3 += rowstride - block_size / 2;
    }

}
