#!/usr/bin/perl

use IO::File;
use smpp;

my ($CONFIG) = "./smsc.cfg";
my $ADDR;
my $PORT;
my $PWD;
my $ID;


sub my_select {
	$rin = $ein = '';
	vec($rin,$receive->get_fileno,1) = 1;
	
	$ein = $rin;
	($nfound, $timeleft) = 
		select($rout=$rin, undef, $eout=$ein, 13);
	if (($nfound > 0) && vec($rout, $receive->get_fileno,1)) {
		return 1;
	}
	return 0;
}

sub read_conf {
	my ($SET_ADDR) = 0;
	my ($SET_PORT) = 0;
	my ($SET_ID) = 0;
	my ($SET_PWD) = 0;

	$FILE = "< " . $CONFIG;
	open FILE or die "$CONFIG: $!\n";
	$error = 0;
	$line = <FILE>;


	while ($error == 0) {
		if (!($SET_PORT) && ($line =~ /^#Default Port/) ) {
			$SET_PORT = 1;
			$line = <FILE>;
			$line =~ /^(\d{4}|\d{5})$/;
			if (!defined($1)) {
				$error = -1;
			}
			else {
				$PORT = $1;
			}
		}
		if (!($SET_ADDR) && ($line =~ /^#Address:/) ) {
			$SET_ADDR = 1;
			$line = <FILE>;
			$line =~ /^(\d+\.\d+\.\d+\.\d+)$/;
			if (!defined($1)) {
				$error = -2;
			}
			else {
				$ADDR = $1;
			}
		}
		if (!($SET_PWD) && ($line =~ /^#Password/) ) {
			$SET_PWD = 1;
			$line = <FILE>;
			$line =~ /^(.*)/;
			if (!defined($1)) {
				$error = -3;
			}
			else {
				$PWD = $1;
			}
		}
		if (!($SET_ID) && ($line =~ /^#System ID/) ) {
			$SET_ID = 1;
			$line = <FILE>;
			$line =~ /^(.*)/;
			if (!defined($1)) {
				$error = -4;
			}
			else {
				$ID = $1;
			}
		}
		else {
			if (!eof(FILE)) {
				$line = <FILE>;
			}
			else {
				$error = -5;
			}
		}
		if (($error == 0) && ($SET_ADDR) && ($SET_PORT)  && ($SET_ID) && ($SET_PWD) ) {
			$error = 1;
		}
	}
	return (($error == 1) ? 0: -1);
}



if ((read_conf) == 0) {
	$Any_Error = 0;
	$receive = new smpp;
	$receive->start_log("ISMSC");
	if ($receive->connect($ADDR, $PORT) != 1) {
		$Any_Error = 2;
	}
	if ($Any_Error != 0) {
		printf("Could not connect to %s:%d\n", $ADDR, $PORT);
	}
	if ($receive->bind_receiver($ID, $PWD) != 1) {
		$Any_Error = 3;
	}
	if ($Any_Error != 0) {
		printf("Bind failed, ID: %s, PWD:%s\n", $ID, $PWD);
		printf("cmd_id cmd_stat seq_num body\n");
		printf("%04x %04x %04x %s\n", $receive->get_cmd_id, $receive->get_cmd_status,  $receive->get_h_seq, $receive->get_body);
		exit;
	}
	while ($Any_Error == 0) {
		if (($sel_ret = my_select) > 0) {
			if ($receive->read_packet == 1) {
				if ($receive->is_deliver == 1) {
					$receive->parse_sm;
					$sms = $receive->get_sms;
					$src = $receive->get_src_addr;
					$dest = $receive->get_dest_addr;
					$receive->deliver_response(1);
					($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = 
						localtime(time);
					$d = sprintf("%04d.%02d.%02d %02d:%02d:%02d", ($year +
								1900), ($mon + 1), $mday, $hour, $min, $sec);
					printf("%s\t%s\t%s\t%s\n", $d, $src, $dest, $sms);
				}
				else {
					$l = 0;
				}
			}
			else {
				$Any_Error = 1;
			}
		}
		else {
			$receive->enquire_link;
		}
	}
	$receive->unbind;
	exit;
}
else {
	printf("Unknown config file format...\n");
}

