#################################################################################
#									
#This package contains functions for communication with an SMSC over SMPP.
#Several SMPP v3.4 functions are implemented, but as we have an SMSC with SMPP
#v3.3, I could not try those.
#This package was tested with Aldiscon/Logica SMSC version 2600.
#Should work with other SMSCs as well. 
#This pm uses syslog user.*, but it generates too many log entries, so maybe you have
#to change your syslog.conf in order to create a separate file for user
#entries.
#
#Use se ts=4, otherwise it doesn't look nice
#
#written by:
#	TORMA SANDOR		<tormas@westel900.hu>
#										
################################################################################
package smpp;
use Sys::Syslog;
use IO::Socket;
#use Exporter;
#use vars qw($VERSION @ISA @EXPORT );
#
#   # set the version for version checking
#$VERSION = "1.00";
#
#@ISA qw(Exporter);
#@EXPORT qw(&new &connect &start_log &stop_log &bind_transmitter &bind_receiver &submit_sm &read_packet &is_deliver &parse_sm &get_src_addr &get_sms &deliver_response &is_enquire_link &enquire_link_response &unbind &disconnect &get_fileno);

%CommandIDs = (
	generic_nack			=>	0x80000000,
	bind_receiver			=>	0x00000001,
	bind_receiver_resp		=>	0x80000001,
	bind_transmitter		=>	0x00000002,
	bind_transmitter_resp	=>	0x80000002,
	query_sm				=>	0x00000003,
	query_sm_resp			=>	0x80000003,
	submit_sm				=>	0x00000004,
	submit_sm_resp			=>	0x80000004,
	deliver_sm				=>	0x00000005,
	deliver_sm_resp			=>	0x80000005,
	unbind					=>	0x00000006,
	unbind_resp				=>	0x80000006,
	replace_sm				=>	0x00000007,
	replace_sm_resp			=>	0x80000007,
	cancel_sm				=>	0x00000008,
	cancel_sm_resp			=>	0x80000008,
	bind_tranceiver			=>	0x00000009,
	bind_tranceiver_resp	=>	0x80000009,
	outbind					=>	0x0000000B,
	submit_multi			=>	0x00000021,
	submit_multi_resp		=>	0x80000021,
	alert_notification		=>	0x00000102,
	data_sm					=>	0x00000103,
	data_sm_resp			=>	0x80000103,
	enquire_link			=>	0x00000015,
	enquire_link_resp		=>	0x80000015,
);
####################################
#	Constructor
####################################
sub new {
	my $class = shift;
	my $self = {};
	($self->{SeqNum}) = 0;
	($self->{Port}) = 0;
	($self->{Hostname}) = "";
	($self->{Handle}) = "";
	$self->{smsh};
	bless $self, $class;
	return $self;
}

####################################
#	Connection handling
####################################

#***********************************
#	Should be rewritten with Socket.pm
#***********************************
sub connect {
	my $self = shift;
	my ($hostname, $port) = @_;
	my ($proto, $smppaddr);
	
	$self->{smsh} = IO::Socket::INET->new(PeerAddr	=> $hostname,
											PeerPort=> $port,
											Proto	=> 'tcp');
#	$sss = sprintf("%d\n", fileno($self->{smsh}));
#	print $sss;
	syslog 'info', 'Connected to %s:%s', $hostname, $port;
	$self->set_port($port);
	$self->set_hostname($hostname);
return 1;
}

sub disconnect {
    my $self = shift;
#	syslog 'info', 'Disconnected from %s:%s', ($self->get_hostname), ($self->get_port);
	close $self->{smsh};
}

sub reconnect {
	my $self = shift;
	($hostname, $port) = @_;	
	$self->disconnect;
	sleep 6;
	$self->connect($hostname, $port);
}

####################################
#	Packet handling
####################################
sub create_packet {
	my $self = shift;
	$self->{Packet} = integer($self->{Length});
	$self->{Packet} .= integer($self->{CommandID});
	$self->{Packet} .= integer($self->{CommandStatus});
	$self->{Packet} .= integer($self->{SequenceNumber});
	$self->{Packet} .= $self->{Body};
}

sub write_packet {
    my $self = shift;
	if ($self->{smsh}->send($self->{Packet}) == length($self->{Packet}) ) {
		$str = sprintf "Message written cmd_id: %x.", ($self->{CommandID});
		syslog ('info', $str); 
	}
	else {
		$str = sprintf "Unable to write cmd_id: %x.", ($self->{CommandID});
		syslog ('err', $str);
	}
#	$self->debug_sm;
	$self->parse_sm;
}

#**********************************************************
#	change read($object,$buff,$len) to $object->recv($buff,$len) 
#	done
#**********************************************************

sub read_packet {
    my $self = shift;
	my $numbytes;

	$self->{smsh}->recv($c,4); 
	if (length($c) < 4 ) {
#		syslog ( 'err', "Read error on handle: %d", scalar(length($c))); 
		print "1read error on handle\n";
		return 0;
	}
	$self->{Length} = unpack("N",$c);

	if ($self->{Length} < 16) {
#		syslog ( 'err', "Length is too short: %d", ($self->{Length}));	
		print "length is short\n";
		return 0;
	}

	$self->{smsh}->recv($c,4); 
	if (length($c) < 4 ) {
#		syslog ( 'err', "Read error on handle: %s", $!); 
		print "2read error on handle\n";
		return 0;
	}
	$self->{CommandID} = unpack("N",$c);

	$self->{smsh}->recv($c,4); 
	if (length($c) < 4 ) {
#		syslog ( 'err', "Read error on handle: %s", $!); 
		print "3read error on handle\n";
		return 0;
	}
	$self->{CommandStatus} = unpack("N",$c);

	$self->{smsh}->recv($c,4); 
	if (length($c) < 4 ) {
#		syslog ( 'err', "Read error on handle: %s", $!); 
		print "4read error on handle\n";
		return 0;
	}
	$self->{SequenceNumber} = unpack("N",$c);

	$self->{smsh}->recv($c,($self->{Length} - 16) ); 
	if (length($c) < ($self->{Length} - 16) ) {
#		syslog ( 'err', "ERead error on handle: %s", $!); 
		print "5read error on handle\n";
		return 0;
	}
	$self->{Body} = $c;
#	$self->debug_sm;
return 1;
}

sub read_and_return {
    my $self = shift;
	my ($a, $b, $c, $d, $e);

	$self->{smsh}->recv($a,4); 
	if (length($a) < 4 ) {
		syslog ( 'err', "Read error on handle: %s, %d", $!, length($a)); 
		return (0, undef);
	}
	$self->{Length} = unpack("N",$a);

	if ($self->{Length} < 16) {
		syslog ( 'err', "Length is too short: %d", ($self->{Length}));	
		return (0, undef);
	}

	$self->{smsh}->recv($b,4); 
	if (length($b) < 4 ) {
		syslog ( 'err', "Read error on handle: %s", $!); 
		return (0, undef);
	}
	$self->{CommandID} = unpack("N",$b);

	$self->{smsh}->recv($c,4); 
	if (length($c) < 4 ) {
		syslog ( 'err', "Read error on handle: %s", $!); 
		return (0, undef);
	}
	$self->{CommandStatus} = unpack("N",$c);

	$self->{smsh}->recv($d,4); 
	if (length($d) < 4 ) {
		syslog ( 'err', "Read error on handle: %s", $!); 
		return (0, undef);
	}
	$self->{SequenceNumber} = unpack("N",$d);

	$self->{smsh}->recv($e,($self->{Length} - 16) ); 
	if (length($e) < ($self->{Length} - 16) ) {
		syslog ( 'err', "Read error on handle: %s", $!); 
		return (0, undef);
	}

	$self->{Body} = $e;

	$packet = $a . $b . $c . $d . $e;
	return (1, $packet);
}

####################################
#	Bindings
####################################
sub bind_receiver {
    my $self = shift;
	my ($uid, $pwd) = @_;
	$self->{CommandID} = $CommandIDs{bind_receiver};	#cmd id
	$self->{CommandStatus} = 0;							#cmd status
	$self->{SequenceNumber} = 0;						#sequence number
	$self->{Body} = c_octet_string($uid);				#username
	$self->{Body} .= c_octet_string("");				#password
	$self->{Body} .= c_octet_string("");				#system type
	$self->{Body} .= short(0);							#interface ver
	$self->{Body} .= short(0);							#addr_ton
	$self->{Body} .= short(0);							#addr_npi
	$self->{Body} .= c_octet_string("");				#address range
	$self->{Length} = 16 + length($self->{Body});		#length
	$self->create_packet;
	$self->write_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{bind_receiver_resp} &&
			$self->{CommandStatus} == 0) {
			syslog ( 'info', "Binded as receiver as %s. ", $uid);
			return 1;
		}
		else {
			syslog ( 'err', "cmd_id: %x, cmd_status: %x", ($self->{CommandID}),($self->{CommandStatus}));
			return 0;
		}
	}
	else {
		return -1;
	}
}

sub bind_transmitter {
	my $self = shift;
	my ($uid, $pwd) = @_;
	$self->{CommandID} = $CommandIDs{bind_transmitter};	#cmd id
	$self->{CommandStatus} = 0;							#cmd status
	$self->{SequenceNumber} = 0; 						#sequence number
	$self->{Body} = c_octet_string($uid);				#system id
	$self->{Body}.= c_octet_string($pwd);				#password
	$self->{Body}.= c_octet_string("");					#system type
	$self->{Body}.= short(0);							#interface ver
	$self->{Body}.= short(0);							#addr_ton
	$self->{Body}.= short(0);							#addr_npi
	$self->{Body}.= c_octet_string("");#address range	#addr_range
	$self->{Length}= 16 + length($self->{Body});		#length
	$self->create_packet;
	$self->write_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{bind_transmitter_resp} &&
			$self->{CommandStatus} == 0) {
			syslog ( 'info', "Binded as transmitter as %s. ", $uid);
			return 1;
		}
		else {
			syslog ( 'err', "cmd_id: %x, cmd_status: %x", ($self->{CommandID}),($self->{CommandStatus}));
			return 0;
		}
	}
	else {
		return -1;
	}
}

sub bind_transceiver {
	my $self = shift;
	my ($uid, $pwd) = @_;
	$self->{CommandID} = $CommandIDs{bind_transceiver}; #cmd id
	$self->{CommandStatus} = 0;							#cmd status
	$self->{SequenceNumber} = $self->seq_num;			#sequence number
	$self->{Body} = c_octet_string($uid);				#username
	$self->{Body} .= c_octet_string($pwd);				#password
	$self->{Body} .= c_octet_string("");				#system type
	$self->{Body} .= short(0);							#interface ver
	$self->{Body} .= short(0);							#addr_ton
	$self->{Body} .= short(0);							#addr_npi
	$self->{Body} .= c_octet_string("");				#address range
	$self->{Length} = 16 + length($self->{Body});		#length
	$self->create_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{bind_transceiver_resp} &&
			$self->{CommandStatus} == 0) {
			syslog ( 'info', "Binded as transceiver as %s. ", $uid);
			return 1;
		}
		else {
			syslog ( 'err', "cmd_id: %x, cmd_status: %x", ($self->{CommandID}),($self->{CommandStatus}));
			return 0;
		}
	}
	else {
		return -1;
	}
}

sub unbind {
    my $self = shift;
	$self->{CommandID} = $CommandIDs{unbind};			#cmd id
	$self->{CommandStatus} = 0;							#cmd status
	$self->{SequenceNumber} = $self->seq_num;			#sequence number
	undef( $self->{Body} );								#body
	$self->{Length} = 16;								#length
	$self->create_packet;
	$self->write_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{unbind_resp} &&
			$self->{CommandStatus} == 0) {
#			syslog ( 'info', "Unbinded from %s. ", $self->{Hostname});
			return 1;
		}
		else {
#			syslog ( 'err', "cmd_id: %x, cmd_status: %x", ($self->{CommandID}),($self->{CommandStatus}));
			return 0;
		}
	}
	else {
		return -1;
	}
}

####################################
#	SMPP methods
####################################
sub submit_sm {
	my $self = shift;
	my ($prior, $sched, $valid, $registered, $src_ton, $src_npi, $src_addr, $dest_ton, $dest_npi, $dest_addr, $sms) = @_;
	$self->{CommandID} = $CommandIDs{submit_sm};		#cmd id
	$self->{CommandStatus} = 0;							#cmd status
	$self->{SequenceNumber} = $self->seq_num;			#sequence number
	$self->{Body} = c_octet_string("");					#service type
	$self->{Body} .= short($src_ton);							#src_addr_ton
	$self->{Body} .= short($src_npi);							#src_addr_npi
	$self->{Body} .= c_octet_string($src_addr);			#src_addr
	$self->{Body} .= short($dest_ton);						#dest_addr_ton
	$self->{Body} .= short($dest_npi);						#dest_addr_npi
	$self->{Body} .= c_octet_string($dest_addr);		#dest_addr
	$self->{Body} .= short(0);							#esm_class
	$self->{Body} .= short(0);							#protocol_id
	$self->{Body} .= short($prior);						#priority_flag
	$self->{Body} .= c_octet_string($sched);			#schedule_time
	$self->{Body} .= c_octet_string($valid);			#validity_period
	$self->{Body} .= short($registered);				#registered_dlv
	$self->{Body} .= short(0);							#replace_flag
#	$self->{Body} .= short(16);							#data_coding villog!
#	rulla!
	$self->{Body} .= short(0);							#data_coding
	$self->{Body} .= short(0);							#sm_def_msg
	$self->{Body} .= short(length($sms) );			#sm_length
	$self->{Body} .= c_octet_string($sms);				#sms
	$self->{Length} = 16 + length($self->{Body});		#length
	$self->create_packet;
	$self->write_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{submit_sm_resp} &&
			$self->{CommandStatus} == 0) {
			syslog ( 'info', "SM submited from %s to %s. ", ($self->{SrcAddr}), ($self->{DestAddr}));
			return 1;
		}
		else {
			syslog ( 'err', "SM submit failed. cmd_id: %x cmd_status: %x",
			($self->{CommandID}), ($self->{CommandStatus}));
			return 0;
		}
	}
	else {
		return -1;
	}
}

sub query_sm {
	my $self = shift;
	my $message_id = @_;
	
	$self->{CommandID} = $CommandIDs{query_sm};			#cmd id
	$self->{SequenceNumber} = $self->seq_num;			#sequence number
	$self->{CommandStatus} = 0;							#cmd status
	$self->{Body} = $message_id;						#message id
	$self->{Body} .= short(0);							#src_addr_ton
	$self->{Body} .= short(0);							#src_addr_npi
	$self->{Body} .= c_octet_string("");				#src_addr
	$self->{Length} = 16 + length($self->{Body});		#length
	$self->create_packet;
	$self->write_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{query_sm_resp} &&
			$self->{CommandStatus} == 0) {
			($final_date, $message_state, $error_code)  = ($self->{Body} =~ /^\w*\x00(\w*)\x00(.)(.)$/);
			syslog ( 'info', "Query Sm id: %x.", $message_id);
			return (1, $final_date, $message_state, $error_code);
		}
		else {
			syslog ( 'err', "Query SM failed. cmd_id: %x cmd_status: %x message id: %x.",
			($self->{CommandID}), ($self->{CommandStatus}), $message_id);
			return (0, undef, undef, undef);
		}
	}
	else {
		return (-1, undef, undef, undef);
	}
}	

sub cancel_sm 
{
	my $self = shift;
	my ($message_id, $source_addr, $dest_addr) = @_;
	
	$self->{CommandID} = $CommandIDs{cancel_sm};		#cmd id
	$self->{SequenceNumber} = $self->seq_num;			#sequence number
	$self->{CommandStatus} = 0;							#cmd status
	$self->{Body} = c_octet_string("");					#service_type
	$self->{Body} .= c_octet_string($message_id);		#message id
	$self->{Body} .= short(1);							#src_addr_ton
	$self->{Body} .= short(1);							#src_addr_npi
	$self->{Body} .= c_octet_string($source_addr);		#src_addr
	$self->{Body} .= short(1);							#dest_addr_ton
	$self->{Body} .= short(1);							#dest_addr_npi
	$self->{Body} .= c_octet_string($dest_addr);		#dest_addr
	$self->{Length} = 16 + length($self->{Body});		#length
    $self->create_packet;
    $self->write_packet;
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{cancel_sm_resp} &&
			$self->{CommandStatus} == 0) {
			syslog ( 'info', "Cancel SM id: %x.", $message_id);
			return 1;
		}
		else {
			syslog ( 'err', "Cancel SM failed. cmd_id: %x cmd_status: %x message id: %x.",
			($self->{CommandID}), ($self->{CommandStatus}), $message_id);
			return 0;
		}
	}
	else {
		return -1;
	}
}	

sub deliver_response {
	my $self = shift;

	my ($success) = @_;

	$self->{CommandID} = $CommandIDs{deliver_sm_resp};	#cmd id
	if ($success) {
	        $self->{CommandStatus} = 0;					#cmd status
	}else{
		$self->{CommandStatus} = 0x0B;
	}
	$self->{Body} = c_octet_string("");					#body
	$self->{Length} = 16 + length($self->{Body});		#length
	$self->create_packet;
	$self->write_packet;
}

sub enquire_link {
	my $self = shift;
	$self->{CommandID} = $CommandIDs{enquire_link};		#cmd id
	$self->{CommandStatus} = 0;							#cmd status
	$self->{SequenceNumber} = $self->seq_num;			#sequence number
	$self->{Body} = "";
#	undef( $self->{Body} );								#body
	$self->{Length} = 16;								#length
	$self->create_packet;
	$self->write_packet;	
	if ($self->read_packet) {
		if ($self->{CommandID} == $CommandIDs{enquire_link_resp} &&
			$self->{CommandStatus} == 0) {
#			syslog ( 'info', "Enquire link: %x.", $message_id);
			return 1;
		}
		else {
#			syslog ( 'err', "Enquire link failed. cmd_id: %x cmd_status: %x message id: %x.",
#			($self->{CommandID}), ($self->{CommandStatus}), $message_id);
			return 0;
		}
	}
	else {
		return -1;
	}
}	

sub enquire_link_resp {
	my $self = shift;
	$self->{CommandID} = $CommandIDs{enquire_link_resp};#cmd id
	$self->{CommandStatus} = 0;							#command status
	undef( $self->{Body} );								#body
	$self->{Length} = 16;								#length
	$self->create_packet;
	$self->write_packet;
}

sub get_unbind {
	my $self = shift;
	my ($msg) = @_;
	$sq = unpack("N", ($msg =~ /^.{4}.{4}.{4}(.{4})$/));
	my ($new) = integer(16);
	$new .= integer($CommandIDs{unbind});
	$new .= integer(0);
	$new .= integer($sq);
	return ($new);
}

###################################
#	Packet Recognition and handling
###################################
sub is_unbind {
	my $self = shift;
	my ($msg) = @_;

	$msg =~ /^(.{4})(.{4})(.{4})(.*)$/; 
	$id = unpack("N", $2);
	return (($id == $CommandIDs{unbind}) ? 1:0);
}
	
sub is_submit {
	my $self = shift;
	return (($self->{CommandID} == $CommandIDs{submit_sm}) 
		? 1 : 0 );
}

sub is_deliver {
	my $self = shift;
	return (($self->{CommandID} == $CommandIDs{deliver_sm}) 
		? 1 : 0 );
}

sub is_enquire_link {
	my $self = shift;
	return (($self->{CommandID} == $CommandIDs{enquire_link}) 
		? 1 : 0);
}

sub is_enquire_link_resp {
	my $self = shift;
	return (($self->{CommandID} == $CommandIDs{enquire_link_resp}) 
		? 1 : 0);
}

sub get_resp {
	my $self = shift;
	my ($msg) = @_;
	$self->{smsh}->send($msg);
}

#sub get_cmd_status {
#	my $self = shift;
#	my ($msg) = @_;
#	$msg =~ /^(.)(.)(.)(.)(.*)$/;
#	$retval = sprintf("%x", unpack("N", $3));
#	return ($retval);
#}

sub forward_msg {
	my $self = shift;
	my ($msg) = @_;
	if ($self->{smsh}->send($msg) != length($msg) ) {
		syslog ('err', 'Forward message failed, peer dropped.');
		return (0, undef);
	}
	else {
		return ($self->read_and_return);
	}
}
#****************************************
#	Should be parse_sm(sm_type);
#****************************************
sub parse_sm {
	my $self = shift;
	$self->{Body} =~ /^(\w*)\x00(.)(.)(\d+)\x00(.)(.)(\d+)\x00(.)(.)(.)(.*?)\x00(.*?)\x00(.)(.)(.)(.)(.)(.*)$/s;
	$self->{ServiceType} = $1;
	$self->{SrcAddrTon} = $2;
	$self->{SrcAddrNpi} = $3;
	$self->{SrcAddr} = $4;
	$self->{DestAddrTon} = $5;
	$self->{DestAddrNpi} = $6;
	$self->{DestAddr} = $7;
	$self->{EsmClass} = $8;
	$self->{ProtocolId} = $9;
	$self->{PriorFl} = $10;
	$self->{SchDelT} = $11;
	$self->{ValidityP} = $12;
	$self->{RegisterDel} = $13;
	$self->{ReplaceIPFl} = $14;
	$self->{DataCoding} = $15;
	$self->{SmDefMsgId} = $16;
	$self->{SmLength} = $17;
	$self->{ShortMessage} = $18;
}

sub get_cmd_id {
	my $self = shift;
	return $self->{CommandID};
}

sub get_cmd_status {
	my $self = shift;
	return $self->{CommandStatus};
}

sub get_h_seq {
	my $self = shift;
	return $self->{SequenceNumber};
}

sub get_body {
	my $self = shift;
	return $self->{Body};
}

sub get_sms {
	my $self = shift;
	return $self->{ShortMessage};
}

##################################
#	Debugging and Logging
##################################
sub debug_sm {
	my $self = shift;
	$self->parse_sm;
	$str = sprintf("%d, %d, %d, %d, %s, %d, %d, %s, %d, %d, %s, %d, %d, %d, %s, %s, %d, %d, %d, %d, %d, %s\n",
	$self->{CommandID}, 
	$self->{SequenceNumber}, 
	$self->{CommandStatus}, 
	$self->{Length}, 
	($self->{ServiceType}),
	unpack("C", $self->{SrcAddrTon}),
	unpack("C", $self->{SrcAddrNpi}),
	($self->{SrcAddr}),
	unpack("C", $self->{DestAddrTon}),
	unpack("C", $self->{DestAddrNpi}),
	($self->{DestAddr}),
	unpack("C", $self->{EsmClass}),
	unpack("C", $self->{ProtocolId}),
	unpack("C", $self->{PriorFl}),
	($self->{SchDelT}),
	($self->{ValidityP}),
	unpack("C", $self->{RegisterDel}),
	unpack("C", $self->{ReplaceIPFl}),
	unpack("C", $self->{DataCoding}),
	unpack("C", $self->{SmDefMsgId}),
	unpack("C", $self->{SmLength}),
	($self->{ShortMessage}));
	print $str;
	print "*************************************************\n";
}

sub print_sms {
	my $self = shift;
	print $self->{ShortMessage};
}

sub start_log{
	my $self = shift;
	my ($prgname) = @_;
	
	Sys::Syslog::setlogsock 'unix';
	openlog $prgname, 'cons,pid', 'user';
	syslog 'info', 'haho';
}

sub log_it {
	my $self = shift;
	my ($level, $what) = @_;

	syslog $level, $what;
}

sub stop_log {
	my $self = shift;
	closelog;
}

##################################
#	class SMPP public:
##################################

sub get_src_ton {
	my $self = shift;
	return ($self->{SrcAddrTon});
}

sub get_src_npi {
	my $self = shift;
	return ($sef->{SrcAddrNpi});
}

sub get_fileno {
	my $self = shift;
	return (fileno($self->{smsh}));
}

sub get_src_addr {
	my $self = shift;
	return ($self->{SrcAddr});
}

sub get_dest_addr {
	my $self = shift;
	return ($self->{DestAddr});
}

sub get_handle {
	my $self = shift;
	return ($self->{smsh});
}

sub get_hostname {
	my $self = shift;
	return ($self->{Hostname});
}

sub get_port {
	my $self = shift;
	return ($self->{Port});
}

sub set_port {
	my $self = shift;
	($self->{Port}) = @_;
}

sub seq_num {
	my $self = shift;
	$self->{SeqNum} += 1;
	$self->{SeqNum} %= 2147483647;
	return ($self->{SeqNum});
}

sub set_hostname {
	my $self = shift;
	($self->{Hostname}) = @_;
}

#################################
#	Type conversions
#################################
sub short {return pack("C",shift);}
sub integer {return pack("N",shift);}
sub c_octet_string {return ((shift).chr(0));}
