#!/usr/bin/perl

use smpp;
use IO::File;

my ($CONFIG) = "./smsc.cfg";
my $ADDR;
my $PORT;
my $PWD;
my $ID;



sub read_conf {
	my ($SET_ADDR) = 0;
	my ($SET_PORT) = 0;
	my ($SET_ID) = 0;
	my ($SET_PWD) = 0;

	$FILE = "< " . $CONFIG;
	open FILE or die "$CONFIG: $!\n";
	$error = 0;
	$line = <FILE>;


	while ($error == 0) {
		if (!($SET_PORT) && ($line =~ /^#Default Port/) ) {
			$SET_PORT = 1;
			$line = <FILE>;
			$line =~ /^(\d{4}|\d{5})$/;
			if (!defined($1)) {
				$error = -1;
			}
			else {
				$PORT = $1;
			}
		}
		if (!($SET_ADDR) && ($line =~ /^#Address:/) ) {
			$SET_ADDR = 1;
			$line = <FILE>;
			$line =~ /^(\d+\.\d+\.\d+\.\d+)$/;
			if (!defined($1)) {
				$error = -2;
			}
			else {
				$ADDR = $1;
			}
		}
		if (!($SET_PWD) && ($line =~ /^#Password/) ) {
			$SET_PWD = 1;
			$line = <FILE>;
			$line =~ /^(.*)/;
			if (!defined($1)) {
				$error = -3;
			}
			else {
				$PWD = $1;
			}
		}
		if (!($SET_ID) && ($line =~ /^#System ID/) ) {
			$SET_ID = 1;
			$line = <FILE>;
			$line =~ /^(.*)/;
			if (!defined($1)) {
				$error = -4;
			}
			else {
				$ID = $1;
			}
		}
		else {
			if (!eof(FILE)) {
				$line = <FILE>;
			}
			else {
				$error = -5;
			}
		}
		if (($error == 0) && ($SET_ADDR) && ($SET_PORT)  && ($SET_ID) && ($SET_PWD) ) {
			$error = 1;
		}
	}
	return (($error == 1) ? 0: -1);
}


if (scalar(@ARGV) != 3) {
	printf("Usage: prg ston.snpi.saddr dton.dnpi.daddr \"text\"\n");
	exit;
}

($ston, $snpi, $saddr) = ($ARGV[0] =~ /^(\d{1})\.(\d{1})\.(.*)/);
if (!defined($ston) || !defined($snpi) || !defined($saddr)) {
	printf("Usage: prg ston.snpi.saddr dton.dnpi.daddr \"text\"\n");
	exit;
}
	
($dton, $dnpi, $daddr) = ($ARGV[1] =~ /^(\d{1})\.(\d{1})\.(.*)/);
if (!defined($dton) || !defined($dnpi) || !defined($daddr)) {
	printf("Usage: prg ston.snpi.saddr dton.dnpi.daddr \"text\"\n");
	exit;
}
$text = $ARGV[2];
if (!defined($text)) {
	printf("Usage: prg ston.snpi.saddr dton.dnpi.daddr \"text\"\n");
	exit;
}

if ((read_conf) == 0) {
	$Any_Error = 0;
	$transmit = new smpp;
	$transmit->start_log("ISMSC");
	if ($transmit->connect($ADDR, $PORT) != 1) {
		$Any_Error = 2;
	}
	if ($Any_Error != 0) {
		printf("Could not connect to %s:%d\n", $ADDR, $PORT);
	}
	if ($transmit->bind_transmitter($ID, $PWD) != 1) {
		$Any_Error = 3;
	}
	if ($Any_Error != 0) {
		printf("Bind failed, ID: %s, PWD:%s\n", $ID, $PWD);
		printf("cmd_id cmd_stat seq_num body\n");
		printf("%04x %04x %04x %s\n", $transmit->get_cmd_id, $transmit->get_cmd_status,  $transmit->get_h_seq, $transmit->get_body);
		exit;
	}
	if (($transmit->submit_sm(0, "", "", 0, $ston, $snpi, $saddr, $dton, $dnpi, $daddr, $text) != 1)) {
		printf("submition failed: got the following response:\n");
		printf("cmd_id cmd_stat seq_num body\n");
		printf("%04x %04x %04x %s\n", $transmit->get_cmd_id, $transmit->get_cmd_status,  $transmit->get_h_seq, $transmit->get_body);
	}
	$transmit->unbind;
	exit;
}
else {
	printf("Unknown config file format...\n");
}

