namespace SharpDoc {
    
    using System.Xml;
    using System;
    using System.Collections;

    public class AssemblyInfoReader {
	
	XmlTextReader reader;
	 
	public AssemblyInfoReader( XmlTextReader reader ) {
	    this.reader = reader;
	}  

	public AssemblyInfo Read() {
	    AssemblyInfo info = new AssemblyInfo();
	    
	    if( ( reader.Name != "AssemblyInfo" ) || ( reader.NodeType != XmlNodeType.Element ) ) {
		throw new ArgumentException("The element is not 'AssemblyInfo'"); 
	    }
	    	    
	    while( true ) {
		
		reader.Read();
		
		// only work with elements
		if( reader.NodeType == XmlNodeType.Element ) {
		    
		    switch( reader.Name ) {
			
				    
		    case "AssemblyName":
			reader.Read();
			info.AssemblyName = reader.Value;
			break;
	
		    case "AssemblyPublicKey":
			reader.Read();
			info.AssemblyPublicKey = reader.Value;
			break;
			
		    case "AssemblyVersion":
			reader.Read();
			info.AssemblyVersion = reader.Value;
			break;
			
		    case "AssemblyCulture":
			reader.Read();
			info.AssemblyCulture = reader.Value;
			break;

		    case "AttributeName":
			reader.Read();
			info.Attributes.Add( reader.Value );
			break;	

		    default:
			// Console.WriteLine("Unexcpected Node '{0}'" , reader.Name );
			
			break;
		    }
		
		
		}
		
		// exit the loop on </AssemblyInfo>
		if( ( reader.NodeType == XmlNodeType.EndElement ) && ( reader.Name == "AssemblyInfo" ) ) break;
		
	    }
	    
	    return info;
	    
	}	

	
		
    }


}
