namespace SharpDoc {
    
    using System.Xml;
    using System;

    public class LibraryReader {
	
	private string fileName;

	public LibraryReader(string fileName) {
	    this.fileName = fileName;
	}

	public TypeList Read() {
	    XmlTextReader reader = new XmlTextReader( fileName );
	    
	    TypeList list = new TypeList();
	    TypeReader typeReader = new TypeReader( reader );

	    
	    int count = 0;
	    while(true) {
		
		 count++;
		 if( count > 5 ) break;
		
		reader.Read();
		
		// only work with elements
		if( reader.NodeType == XmlNodeType.Element ) {
		    
		    switch( reader.Name ) {
			
		    case "Type": 
			Console.Write("+");
			TypeItem type = typeReader.Read();
			list.AddType( type );
			Console.Write("\b*");
			break;
					
			

		    default:
			// Console.WriteLine("Unexcpected Node '{0}'" , reader.Name );
			
			break;
		    }
		
		
		}
		
	       
		// exit the loop on </Library>
		if( ( reader.NodeType == XmlNodeType.EndElement ) && ( reader.Name == "Libraries" ) ) break;
	    }
	    
	    Console.WriteLine();
	    
	    return list;
	}
	

	
    }


}
