namespace SharpDoc {
    
    using System.Xml;
    using System;

    public class MemberReader {
	
	XmlTextReader reader;
	
	public MemberReader( XmlTextReader reader ) {
	    this.reader = reader;
	}  

	public MemberItem Read() {
	    MemberItem member = new MemberItem();
	    DocsReader docsReader = new DocsReader( reader );

	    if( ( reader.Name != "Member" ) || ( reader.NodeType != XmlNodeType.Element ) ) {
		throw new ArgumentException("The element is not 'Member'"); 
	    }
	    
	    member.Name = reader[ "MemberName" ];
	    member.FullName = "";
	    
	    
	    while( true ) {
		
		reader.Read();
		
		// only work with elements
		if( reader.NodeType == XmlNodeType.Element ) {
		    
		    switch( reader.Name ) {
			
		    case "Docs": member.Docs = docsReader.Read();  break;
		
		    case "MemberSignature":
			if( reader["Language"] == "C#" ) member.Signature = reader["Value"];  
			if( reader["Language"] == "ILASM" ) member.ILASMSignature = reader["Value"]; 
			break;	

		    case "MemberType":
			reader.Read();
			member.MemberType = reader.Value;  	
			break;

		    case "ReturnType":
			reader.Read();
			member.ReturnType = reader.Value;  	
			break;

		    case "Parameter":
			ParameterItem par = new ParameterItem();
			
			par.Name = reader["Name"];
			par.Type = reader["Type"];
			
			member.Parameters.Add( par );
			
			break;
		    			
		    default:
			// Console.WriteLine("Unexcpected Node '{0}'" , reader.Name );
			
			break;
		    }
		
		
		}
		
		// exit the loop on </Member>
		if( ( reader.NodeType == XmlNodeType.EndElement ) && ( reader.Name == "Member" ) ) break;
		
	    }
	    
	    return member;
	    
	}	

       	
    }


}
