namespace SharpDoc {
    
    using System;
    using System.Collections;

    public class TypeItem : DocNode , IComparable {

	private AssemblyInfo info;
	private ArrayList interfaces = new ArrayList();
	private ArrayList members = new ArrayList();

	private string memberOfLibrary;
	private string threadingSafetyStatement;
	private string baseType;


	public int CompareTo(object other) {
	    TypeItem otherType = (TypeItem)other;
	    return Name.CompareTo( otherType.Name );
	}


	public ArrayList Members {
	    get { return members; }
	    set { members = value; } 
	}

	public AssemblyInfo AssemblyInfo {
	    get { return info; }
	    set { info = value; } 
	}

	public ArrayList Interfaces {
	   get { return interfaces; }
	   set { interfaces = value; } 
	}

	
	public string MemberOfLibrary {
	    get { return memberOfLibrary;  }
	    set { memberOfLibrary = value; }
	}
	
	public string ThreadingSafetyStatement {
	    get { return threadingSafetyStatement;  }
	    set { threadingSafetyStatement = value; }
	}

	public string BaseType {
	    get { return baseType;  }
	    set { baseType = value; }
	}
    }

}
