namespace SharpDoc {
    
    using System.Xml;
    using System;

    public class TypeReader {
	
	XmlTextReader reader;
	 
	public TypeReader( XmlTextReader reader ) {
	    this.reader = reader;
	}  

	public TypeItem Read() {
	    TypeItem type = new TypeItem();
	    DocsReader docsReader = new DocsReader( reader );
	    MemberReader memberReader = new MemberReader( reader );

	    if( ( reader.Name != "Type" ) || ( reader.NodeType != XmlNodeType.Element ) ) {
		throw new ArgumentException("The element is not 'Type'"); 
	    }
	    
	    type.Name = reader[ "Name" ];
	    type.FullName = reader[ "FullName" ];
	    
	    

	    while( true ) {
		
		reader.Read();
		
		// only work with elements
		if( reader.NodeType == XmlNodeType.Element ) {
		    
		    switch( reader.Name ) {
			
		    case "Docs": type.Docs = docsReader.Read();  break;
					
		    case "TypeSignature":
			if( reader["Language"] == "C#" ) type.Signature = reader["Value"];  
			if( reader["Language"] == "ILASM" ) type.ILASMSignature = reader["Value"]; 
			break;
		    
		    case "AssemblyInfo":
			AssemblyInfoReader infoReader = new AssemblyInfoReader( reader );
			type.AssemblyInfo = infoReader.Read();
			break;

		    case "MemberOfLibrary": 
			reader.Read();
			type.MemberOfLibrary = reader.Value; 
			break;  
			
		    case "ThreadingSafetyStatement":
			reader.Read();
			type.ThreadingSafetyStatement = reader.Value; 
			break;
		    
		    case "BaseTypeName":
			reader.Read();
			type.BaseType = reader.Value; 
			break;	
			
		    case "InterfaceName":
			reader.Read();
			type.Interfaces.Add( reader.Value ); 
			break;	

		    case "Member":
			MemberItem member = memberReader.Read();
			type.Members.Add( member );
			break;

		    default:
			// Console.WriteLine("Unexcpected Node '{0}'" , reader.Name );
			
			break;
		    }
		
		
		}
		
		// exit the loop on </Type>
		if( ( reader.NodeType == XmlNodeType.EndElement ) && ( reader.Name == "Type" ) ) break;
		
	    }
	    
	    return type;
	    
	}	

       	
    }


}
