/*
 * DrawableKind.cs - Kinds of drawables that are present in the system.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows
{

using System;

/// <summary>
/// <para>The <see cref="T:XWindows.DrawableKind"/> enumeration specifies
/// the kinds of drawable that may be present in the system (one of
/// "widget", "input-only widget", or "pixmap").</para>
/// </summary>
public enum DrawableKind
{

	Widget          = 0,
	InputOnlyWidget = 1,
	Pixmap          = 2,
	Bitmap          = 2

} // enum DrawableKind

} // namespace XWindows
