/*
 * XMappingEvent.cs - Definitions for X event structures.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows.Events
{

using System;
using System.Runtime.InteropServices;

// Key mapping event.
[StructLayout(LayoutKind.Sequential)]
internal struct XMappingEvent
{
	// Structure fields.
	XAnyEvent			common__;
	public Xlib.Xint	request__;
	public Xlib.Xint	first_keycode__;
	public Xlib.Xint	count__;

	// Access parent class fields.
	public int type           { get { return common__.type; } }
	public uint serial        { get { return common__.serial; } }
	public bool send_event    { get { return common__.send_event; } }
	public IntPtr display     { get { return common__.display; } }
	public Xlib.Window window { get { return common__.window; } }

	// Convert odd fields into types that are useful.
	public int request        { get { return (int)request__; } }
	public int first_keycode  { get { return (int)first_keycode__; } }
	public int count          { get { return (int)count__; } }

} // struct XMappingEvent

} // namespace XWindows.Events
