/*
 * XNoExposeEvent.cs - Definitions for X event structures.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows.Events
{

using System;
using System.Runtime.InteropServices;

// No expose event.
[StructLayout(LayoutKind.Sequential)]
internal struct XNoExposeEvent
{
	// Structure fields.
	XAnyEvent			common__;
	public Xlib.Xint	major_code__;
	public Xlib.Xint	minor_code__;

	// Access parent class fields.
	public int type           { get { return common__.type; } }
	public uint serial        { get { return common__.serial; } }
	public bool send_event    { get { return common__.send_event; } }
	public IntPtr display     { get { return common__.display; } }
	public Xlib.Drawable drawable
			{ get { return (Xlib.Drawable)common__.window; } }

	// Convert odd fields into types that are useful.
	public int major_code     { get { return (int)major_code__; } }
	public int minor_code     { get { return (int)minor_code__; } }

} // struct XNoExposeEvent

} // namespace XWindows.Events
