/*
 * CreateWindowMask.cs - Value mask values for "XCreateWindow".
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows.Types
{

using System;

[Flags]
internal enum CreateWindowMask
{

	CWBackPixmap		= (1<<0),
	CWBackPixel			= (1<<1),
	CWBorderPixmap		= (1<<2),
	CWBorderPixel       = (1<<3),
	CWBitGravity		= (1<<4),
	CWWinGravity		= (1<<5),
	CWBackingStore      = (1<<6),
	CWBackingPlanes	    = (1<<7),
	CWBackingPixel	    = (1<<8),
	CWOverrideRedirect	= (1<<9),
	CWSaveUnder			= (1<<10),
	CWEventMask			= (1<<11),
	CWDontPropagate	    = (1<<12),
	CWColormap			= (1<<13),
	CWCursor	        = (1<<14)

} // enum CreateWindowMask

} // namespace XWindows.Types
