/*
 * GCValueMask.cs - GC value mask values.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows.Types
{

using System;

[Flags]
internal enum GCValueMask
{

	GCFunction          = (1<<0),
	GCPlaneMask         = (1<<1),
	GCForeground        = (1<<2),
	GCBackground        = (1<<3),
	GCLineWidth         = (1<<4),
	GCLineStyle         = (1<<5),
	GCCapStyle          = (1<<6),
	GCJoinStyle		    = (1<<7),
	GCFillStyle		    = (1<<8),
	GCFillRule		    = (1<<9) ,
	GCTile			    = (1<<10),
	GCStipple		    = (1<<11),
	GCTileStipXOrigin   = (1<<12),
	GCTileStipYOrigin   = (1<<13),
	GCFont 			    = (1<<14),
	GCSubwindowMode		= (1<<15),
	GCGraphicsExposures = (1<<16),
	GCClipXOrigin		= (1<<17),
	GCClipYOrigin		= (1<<18),
	GCClipMask		    = (1<<19),
	GCDashOffset		= (1<<20),
	GCDashList		    = (1<<21),
	GCArcMode		    = (1<<22)

} // enum GCValueMask

} // namespace XWindows.Types
