/*
 * XCannotConnectException.cs - Exception that is thrown when X#
 *		cannot connect to an X display server.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows
{

using System;

/// <summary>
/// <para>Exception type that is thrown when <c>XWindows.Display.Open</c>
/// cannot connect to an X display server.</para>
/// </summary>
public sealed class XCannotConnectException : XException
{

	// Constructors.
	public XCannotConnectException()
		: base(S._("X_CannotOpen")) {}
	public XCannotConnectException(String msg)
		: base(msg) {}
	public XCannotConnectException(String msg, Exception inner)
		: base(msg, inner) {}

} // class XCannotConnectException

} // namespace XWindows
