/*
 * Xlib.cs - Native method interface for Xlib.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace XWindows
{

using System;
using System.Runtime.InteropServices;
using XWindows.Events;
using XWindows.Types;

internal sealed class Xlib
{
	// Declare Xlib types that may be different sizes on different platforms.
	//
	// Declaring these as enumerated types is a C# trick to get a new
	// integer type of the correct size that is guaranteed to be marshalled
	// to Xlib in the same way as the underlying integer type.

	public enum Pixel    : uint { Zero }
	public enum XID      : uint { Zero }
	public enum Mask     : uint { Zero }
	public enum Atom     : uint { Zero }
	public enum VisualID : uint { Zero }
	public enum Time     : uint { CurrentTime }
	public enum Window   : uint { Zero }
	public enum Drawable : uint { Zero }
	public enum Font     : uint { Zero }
	public enum Pixmap   : uint { Zero }
	public enum Cursor   : uint { Zero }
	public enum Colormap : uint { Zero }
	public enum GContext : uint { Zero }
	public enum KeySym   : uint { Zero }
	public enum KeyCode  : byte { Zero }
	public enum Bool     : int { False, True }
	public enum Status   : int { Zero }
	public enum Xint     : int { Zero }
	public enum Xuint    : uint { Zero }
	public enum Xlong    : int { Zero }
	public enum Xulong   : uint { Zero }

	// Declare display-related external functions.

	[DllImport("X11")]
	extern public static Status XInitThreads();

	[DllImport("X11")]
	extern public static IntPtr XOpenDisplay(String display_name);

	[DllImport("X11")]
	extern public static int XCloseDisplay(IntPtr display);

	[DllImport("X11")]
	extern public static String XDisplayName(String str);

	[DllImport("X11")]
	extern public static int XScreenCount(IntPtr display);

	[DllImport("X11")]
	extern public static IntPtr XScreenOfDisplay(IntPtr display, int scr);

	[DllImport("X11")]
	extern public static int XDefaultScreen(IntPtr display);

	[DllImport("X11")]
	extern public static String XDisplayString(IntPtr display);

	[DllImport("X11")]
	extern public static int XFlush(IntPtr display);

	[DllImport("X11")]
	extern public static int XSync(IntPtr display, Bool discard);

	[DllImport("X11")]
	extern public static int XBell(IntPtr display, int percent);

	// Declare screen-related external functions.

	[DllImport("X11")]
	extern public static Window XRootWindowOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static Pixel XBlackPixelOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static Pixel XWhitePixelOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static Colormap XDefaultColormapOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static int XDefaultDepthOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static int XWidthOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static int XHeightOfScreen(IntPtr screen);

	[DllImport("X11")]
	extern public static IntPtr XDefaultVisualOfScreen(IntPtr screen);

	// Declare window-related external functions.

	[DllImport("X11")]
	extern public static Window XCreateWindow
			(IntPtr display, Window parent, int x, int y,
		     uint width, uint height, uint border_width,
			 int depth, int c_class, IntPtr visual,
			 uint value_mask, ref XSetWindowAttributes values);

	[DllImport("X11")]
	extern public static Window XCreateWindow
			(IntPtr display, Window parent, int x, int y,
		     uint width, uint height, uint border_width,
			 int depth, int c_class, IntPtr visual,
			 uint value_mask, IntPtr values); // for values == null.

	[DllImport("X11")]
	extern public static int XDestroyWindow(IntPtr display, Window w);

	[DllImport("X11")]
	extern public static int XMoveWindow
			(IntPtr display, Window w, int x, int y);

	[DllImport("X11")]
	extern public static int XResizeWindow
			(IntPtr display, Window w, uint width, uint height);

	[DllImport("X11")]
	extern public static int XMoveResizeWindow
			(IntPtr display, Window w, int x, int y,
			 uint width, uint height);

	[DllImport("X11")]
	extern public static int XConfigureWindow
			(IntPtr display, Window w, uint value_mask,
			 ref XWindowChanges changes);

	[DllImport("X11")]
	extern public static int XMapWindow(IntPtr display, Window w);

	[DllImport("X11")]
	extern public static int XMapRaised(IntPtr display, Window w);

	[DllImport("X11")]
	extern public static int XUnmapWindow(IntPtr display, Window w);

	[DllImport("X11")]
	extern public static Status XWithdrawWindow
			(IntPtr display, Window w, int screen_number);

	[DllImport("X11")]
	extern public static Status XIconifyWindow
			(IntPtr display, Window w, int screen_number);

	[DllImport("X11")]
	extern public static Cursor XCreateFontCursor
			(IntPtr display, uint shape);

	[DllImport("X11")]
	extern public static int XDefineCursor
			(IntPtr display, Window w, Cursor cursor);

	[DllImport("X11")]
	extern public static int XUndefineCursor(IntPtr display, Window w);

	[DllImport("X11")]
	extern public static int XSetWindowBackground
			(IntPtr display, Window w, Pixel background_pixel);

	[DllImport("X11")]
	extern public static int XClearArea
			(IntPtr display, Window w, int x, int y,
			 uint width, uint height, Bool exposures);

	// Declare pixmap-related external functions.

	[DllImport("X11")]
	extern public static Xlib.Pixmap XCreatePixmap
			(IntPtr display, Xlib.Drawable d, uint width,
			 uint height, uint depth);

	[DllImport("X11")]
	extern public static int XFreePixmap
			(IntPtr display, Xlib.Pixmap pixmap);

	// Declare region-related external functions.

	[DllImport("X11")]
	extern public static IntPtr XCreateRegion();

	[DllImport("X11")]
	extern public static int XDestroyRegion(IntPtr r);

	[DllImport("X11")]
	extern public static int XUnionRegion(IntPtr sra, IntPtr srb,
											  IntPtr dr_return);

	[DllImport("X11")]
	extern public static int XUnionRectWithRegion
			(ref XRectangle rectangle, IntPtr src, IntPtr dest);

	[DllImport("X11")]
	extern public static int XIntersectRegion(IntPtr sra, IntPtr srb,
											      IntPtr dr_return);

	[DllImport("X11")]
	extern public static int XSubtractRegion(IntPtr sra, IntPtr srb,
											     IntPtr dr_return);

	[DllImport("X11")]
	extern public static int XXorRegion(IntPtr sra, IntPtr srb,
										    IntPtr dr_return);

	[DllImport("X11")]
	extern public static int XEmptyRegion(IntPtr r);

	[DllImport("X11")]
	extern public static int XEqualRegion(IntPtr r1, IntPtr r2);

	[DllImport("X11")]
	extern public static int XOffsetRegion
			(IntPtr r, int dx, int dy);

	[DllImport("X11")]
	extern public static int XShrinkRegion
			(IntPtr r, int dx, int dy);

	[DllImport("X11")]
	extern public static int XPointInRegion
			(IntPtr r, int x, int y);

	[DllImport("X11")]
	extern public static IntPtr XPolygonRegion
			(XPoint[] points, int n, int fill_rule);

	[DllImport("X11")]
	extern public static int XClipBox(IntPtr region, out XRectangle rect);

	[DllImport("X11")]
	extern public static int XRectInRegion
			(IntPtr region, int x, int y,
			 uint width, uint height);

	// Declare event-related external functions.

	[DllImport("X11")]
	extern public static int XNextEvent(IntPtr display, out XEvent xevent);

	[DllImport("X11")]
	extern public static int XEventsQueued(IntPtr display, int mode);

	[DllImport("X11")]
	extern public static int XSelectInput(IntPtr display, Window w,
											  int mode);

	// Declare GC-related external functions.

	[DllImport("X11")]
	extern public static IntPtr XCreateGC(IntPtr display,
										  Xlib.Drawable drawable,
										  uint values_mask,
										  ref XGCValues values);

	[DllImport("X11")]
	extern public static int XFreeGC(IntPtr display, IntPtr gc);

	[DllImport("X11")]
	extern public static int XChangeGC(IntPtr display, IntPtr gc,
										   uint values_mask,
										   ref XGCValues values);

	[DllImport("X11")]
	extern public static int XGetGCValues(IntPtr display, IntPtr gc,
										      uint values_mask,
										      out XGCValues values);

	[DllImport("X11")]
	extern public static int XSetForeground
			(IntPtr display, IntPtr gc, Xlib.Pixel foreground);

	[DllImport("X11")]
	extern public static int XSetBackground
			(IntPtr display, IntPtr gc, Xlib.Pixel background);

	[DllImport("X11")]
	extern public static int XSetFunction
			(IntPtr display, IntPtr gc, int function);

	[DllImport("X11")]
	extern public static int XSetFillStyle
			(IntPtr display, IntPtr gc, int fill_style);

	[DllImport("X11")]
	extern public static int XSetTile
			(IntPtr display, IntPtr gc, Pixmap tile);

	[DllImport("X11")]
	extern public static int XSetStipple
			(IntPtr display, IntPtr gc, Pixmap stipple);

	[DllImport("X11")]
	extern public static int XSetTSOrigin
			(IntPtr display, IntPtr gc, int ts_x_origin,
			 int ts_y_origin);

	[DllImport("X11")]
	extern public static int XSetRegion
			(IntPtr display, IntPtr gc, IntPtr r);

	[DllImport("X11")]
	extern public static int XSetClipMask
			(IntPtr display, IntPtr gc, Pixmap pixmap);

	[DllImport("X11")]
	extern public static int XSetClipOrigin
			(IntPtr display, IntPtr gc, int x, int y);

	[DllImport("X11")]
	extern public static int XDrawLine
			(IntPtr display, Drawable drawable, IntPtr gc,
			 int x1, int y1, int x2, int y2);

	// Declare window manager related external functions.

	[DllImport("X11")]
	extern public static int XStoreName
			(IntPtr display, Xlib.Window w, String window_name);

	[DllImport("X11")]
	extern public static int XSetIconName
			(IntPtr display, Xlib.Window w, String window_name);

	// Declare color-related external functions.

	[DllImport("X11")]
	extern public static int XAllocColor
			(IntPtr display, Xlib.Colormap colormap, ref XColor xcolor);

} // class Xlib

} // namespace XWindows
