/*
 * XHello.cs - Sample program for X#.
 *
 * This file is part of the X# library.
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Threading;
using XWindows;

public class XHello
{
	// Main entry point.
	public static void Main()
	{
		Display dpy = Display.Open(null);
		Widget root = dpy.DefaultRootWindow;
		TopLevelWindow topLevel = new TopLevelWindow("Hello World!", 200, 200);
		topLevel.Background = new Color(0xFF, 0xFF, 0xFF);
		topLevel.Paint += new PaintEventHandler(PaintHello);
		topLevel.Map();
		dpy.Flush();
		dpy.Run();
		dpy.Close();
	}

	// Paint the top-level window.
	public static void PaintHello(Widget widget, Canvas canvas)
	{
		canvas.DrawLine(0, 0, widget.Width, widget.Height);
		canvas.DrawLine(0, widget.Height, widget.Width, 0);
	}

} // class XHello
