MCS = mcs
MCS_FLAGS = /nologo /optimize /target:exe /r:System.dll /r:Mono.GetOptions.dll  $(MCS_DEFINES)
INSTALL = /usr/bin/install
prefix = /usr

COMPILER_SOURCES = \
	AssemblyInfo.cs   \
	assign.cs		\
	attribute.cs		\
	cfold.cs		\
	class.cs 		\
	codegen.cs		\
	const.cs		\
	constant.cs		\
	decl.cs			\
	delegate.cs		\
	driver.cs $(COMMON_SOURCES) \
	enum.cs			\
	ecore.cs		\
	expression.cs 		\
	genericparser.cs	\
	interface.cs		\
	literal.cs		\
	location.cs 		\
	mb-parser.cs 		\
	mb-tokenizer.cs 	\
	modifiers.cs 		\
	module.cs		\
	namespace.cs		\
	parameter.cs		\
	pending.cs		\
	report.cs		\
	rootcontext.cs		\
	statement.cs		\
	statementCollection.cs	\
	support.cs		\
	tree.cs 		\
	typemanager.cs


all: mbas.exe

mbas.exe: $(COMPILER_SOURCES) 
	$(MCS) $(MCS_FLAGS) -o $@ $(COMPILER_SOURCES)

mbas-mono2.exe: $(COMPILER_SOURCES)
	$(MCS) $(MCS_FLAGS) --debug -o $@ $(COMPILER_SOURCES)

mb-parser.cs: mb-parser.jay
	../jay/jay -ctv < ../jay/skeleton.cs mb-parser.jay > mb-parser.cs

clean:
	rm -f mbas.exe y.output mbas.pdb *~ .*~ mb-parser.cs mbas.log response

install: all
	mkdir -p $(prefix)/bin/
	$(INSTALL) -m 755 mbas.exe $(prefix)/bin/

test:
	mono mbas.exe testmbas/WriteOK.vb 

test-gtk:
	mono mbas.exe testmbas/gtk.vb -r gtk-sharp



