/*
	FreeRTOS V1.2.0 - Copyright (C) 2003 Richard Barry.

	Licensed under the Open Software License version 1.1

	The file main.c and related documentation is part of the FreeRTOS
	distribution.  Any and all data files, source code and documentation
	included in the FreeRTOS distribution are the exclusive property of
	Richard Barry.

	See www.FreeRTOS.org for documentation, license and warranty details.
*/

#include <msp430x44x.h>
#include <stdlib.h>
// #include <string.h>

/* Scheduler include files. */
#include "projdefs.h"
#include "portable.h"
#include "task.h"

typedef enum {FALSE,TRUE} BOOL;


void vTestTask( void *pvParameters );
unsigned short InitFll(BOOL dcoplus, unsigned char n, unsigned char d);

portSHORT main( void )
{
  	WDTCTL = WDTPW +WDTHOLD;              // Stop WDT
  	InitFll(TRUE,108,1);                  // 7.1434 MHz (2 * (108+1) * 32768)

	sTaskCreate( vTestTask, "Check", portMINIMAL_STACK_SIZE, NULL, 0, NULL );

	/* In this port, to use preemptive scheduler define portUSE_PREEMPTION
	as 1 in portmacro.h.  To use the cooperative scheduler define
	portUSE_PREEMPTION as 0. */

	vTaskStartScheduler( portUSE_PREEMPTION );

	return 0;
}
/*-----------------------------------------------------------*/

void vTestTask( void *pvParameters )
{
	/* Cycle for ever, delaying then checking all the other tasks are still
	operating without error. */
	portSHORT dummy;

	dummy = (portSHORT)pvParameters;
	if(dummy == 0)
	{
		for( ;; )
		{
			vTaskDelay( 2 );
		}
	}
}


/*********************************************************************
  Initialisierung der FLL
  Das DCO+ Bit wird gesetzt, wenn dcoplus == TRUE
  Die resultierende Frequenz ist:

  DCO+ = 0: f = (n+1)*32768 Hz
  DCO+ = 1: f = (d+1)*(n+1) * 32768 Hz;

  !!!!!!!!!!!!
  (d+1) steht nicht im Datenblatt sondern ergibt sich aus der Progr.
  !!!!!!!!!!!!

	XCAP0PF,XCAP10PF,XCAP14PF,XCAP18PF sind als Parameter mgl.
*********************************************************************/
unsigned short InitFll(BOOL dcoplus, unsigned char n, unsigned char d)
{
  if(dcoplus == TRUE)
    FLL_CTL0 = XCAP10PF | DCOPLUS; 	// Configure load caps and DCOPLUS
  else
    FLL_CTL0 = XCAP10PF;            	// Configure load caps

//  SCFQCTL = (n & 0x7f) | SCFQ_M;  // Multiplikationsfaktor setzen,
									// Modulation sperren
  SCFQCTL = (n & 0x7f);				// Multiplikationsfaktor setzen
  SCFI0 = ((d & 3) << 6) | FN_3;
  return(0);
}
