/*
	FreeRTOS V1.2.0 - Copyright (C) 2003 Richard Barry.

	Licensed under the Open Software License version 1.1

	The file portable.h and related documentation is part of the FreeRTOS
	distribution.  Any and all data files, source code and documentation
	included in the FreeRTOS distribution are the exclusive property of
	Richard Barry.

	See www.FreeRTOS.org for documentation, license and warranty details.
*/

/*-----------------------------------------------------------
 * Portable layer API.  Each function must be defined for each port.
 *----------------------------------------------------------*/

#ifndef PORTABLE_H
#define PORTABLE_H

/* Include the macro file relevant to the port being used. */


#include "portmacro.h"
#include "projdefs.h"


/*
 * Setup the stack of a new task so it is ready to be placed under the
 * scheduler control.  The registers have to be placed on the stack in
 * the order that the port expects to find them.
 */
portSTACK_TYPE *pxPortInitialiseStack( portSTACK_TYPE *pxTopOfStack, pdTASK_CODE pxCode, void *pvParameters );

/*
 * Map to the memory management routines required for the port.
 */
void *pvPortMalloc( unsigned portSHORT usSize );
void vPortFree( void *pv );

/*
 * Setup the hardware ready for the scheduler to take control.  This generally
 * sets up a tick interrupt and sets timers for the correct tick frequency.
 */
portSHORT sPortStartScheduler( portSHORT sUsePreemption );

/*
 * Undo any hardware/ISR setup that was performed by sPortStartScheduler() so
 * the hardware is left in its original condition after the scheduler stops
 * executing.
 */
void vPortEndScheduler( void );

/*
 * Finds the high water mark of stack usage.  Returns the smallest amount of
 * free stack that has been available since the task started.
 *
 * THIS FUNCTION IS INTENDED FOR DEBUGGING ONLY, AND SHOULD NOT BE CALLED FROM
 * NORMAL APPLICATION CODE>
 */
unsigned portSHORT usPortCheckFreeStackSpace( const unsigned portCHAR *pucStackByte, unsigned portCHAR ucStackFillByte );

#endif /* PORTABLE_H */
