/*
	FreeRTOS V1.2.0 - Copyright (C) 2003 Richard Barry.

	Licensed under the Open Software License version 1.1

	The file portheap.c and related documentation is part of the FreeRTOS
	distribution.  Any and all data files, source code and documentation
	included in the FreeRTOS distribution are the exclusive property of
	Richard Barry.

	See www.FreeRTOS.org for documentation, license and warranty details.
*/

/*-----------------------------------------------------------
 * Very basic block allocation scheme.  This is tailored exactly for the demo
 * application needs and should be tuned or replaced for any other application.
 *----------------------------------------------------------*/

/* Compiler include files. */
#include <stdlib.h>

/* Scheduler include files. */
#include "projdefs.h"
#include "portable.h"
#include "task.h"

#define heapSMALL_BLOCK_SIZE		( ( unsigned portSHORT ) sizeof (tskTCB) )
#define heapLARGE_BLOCK_SIZE		portMINIMAL_STACK_SIZE

/* These are the number of blocks required by the demo application. */
#define heapNUM_SMALL_BLOCKS		( 5 )
#define heapNUM_LARGE_BLOCKS		( 10 )

/* Each block contains the data area and a variable that marks the block as
empty of full. */
typedef struct
{
	unsigned portSHORT ucFull;
	unsigned portCHAR ucBlock[ (heapSMALL_BLOCK_SIZE/2 + 1) * 2 ];
} xSmallBlock;

typedef struct
{
	unsigned portSHORT ucFull;
	unsigned portCHAR ucBlock[ heapLARGE_BLOCK_SIZE & 0xFFFE];	// geradzahlig machen
} xLargeBlock;

//static xSmallBlock xSmallBlocks[ heapNUM_SMALL_BLOCKS ];
//static xLargeBlock xLargeBlocks[ heapNUM_LARGE_BLOCKS ];

//xSmallBlock xSmallBlocks[ heapNUM_SMALL_BLOCKS ];
//xLargeBlock xLargeBlocks[ heapNUM_LARGE_BLOCKS ];


extern unsigned portSHORT usSaveStatusRegister;


/*-----------------------------------------------------------*/
void *pvPortMalloc( unsigned portSHORT usSize )
{
void *pv = NULL;
unsigned portCHAR ucBlock;

	portENTER_CRITICAL();
	{
		pv = malloc(usSize);
/*
		if( usSize <= heapSMALL_BLOCK_SIZE )
		{
			// Try to find a block in the list of small blocks.
			for( ucBlock = 0; ucBlock < heapNUM_SMALL_BLOCKS; ucBlock++ )
			{
				if( xSmallBlocks[ ucBlock ].ucFull == pdFALSE )
				{
					xSmallBlocks[ ucBlock ].ucFull = pdTRUE;
					pv = ( void * ) ( xSmallBlocks[ ucBlock ].ucBlock );
					break;
				}
			}
		}

		// If the block is too large to be obtained from the pool of small
		//blocks, or if a small block could not be found, try to find a block
		//in the list of large blocks.
		if( ( usSize <= heapLARGE_BLOCK_SIZE ) && ( pv == NULL ) )
		{
			for( ucBlock = 0; ucBlock < heapNUM_LARGE_BLOCKS; ucBlock++ )
			{
				if( xLargeBlocks[ ucBlock ].ucFull == pdFALSE )
				{
					xLargeBlocks[ ucBlock ].ucFull = pdTRUE;
					pv = ( void * ) ( xLargeBlocks[ ucBlock ].ucBlock );
					break;
				}
			}
		}*/
	}
	portEXIT_CRITICAL();

	return pv;
}
/*-----------------------------------------------------------*/

void vPortFree( void *pv )
{
	/* The AVR demo application does not use any calls to free(). */
	pv = NULL;
}
/*-----------------------------------------------------------*/

