/*
	FreeRTOS V1.2.0 - Copyright (C) 2003 Richard Barry.

	Licensed under the Open Software License version 1.1

	The file portmacro.h and related documentation is part of the FreeRTOS
	distribution.  Any and all data files, source code and documentation
	included in the FreeRTOS distribution are the exclusive property of
	Richard Barry.

	See www.FreeRTOS.org for documentation, license and warranty details.
*/

#ifndef PORTMACRO_H
#define PORTMACRO_H

// #include <io.h>

/*-----------------------------------------------------------
 * Port specific definitions for the industrial PC port.
 *----------------------------------------------------------*/

/* These are the only definitions that can be modified!. */
#define portUSE_PREEMPTION		1
#define portCPU_CLOCK_HZ		( ( unsigned portLONG ) 0x800000 )
#define portTICK_RATE_HZ		( ( unsigned portLONG ) 1000 )
#define portMAX_PRIORITIES		( ( unsigned portCHAR ) 4 )
#define portMINIMAL_STACK_SIZE	( ( unsigned portSHORT ) 80 )

/*-----------------------------------------------------------
 * Do not modify anything below here.
 *----------------------------------------------------------*/

#define portCHAR		char
#define portFLOAT		float
#define portDOUBLE		double
#define portLONG		long
#define portSHORT		int

#define portSTACK_TYPE	unsigned portSHORT

/*-----------------------------------------------------------*/

#define portENTER_CRITICAL()		asm volatile ( "mov r2, %0":"=m"(usSaveStatusRegister));\
									asm volatile ( "dint" :: );

#define portEXIT_CRITICAL()			asm volatile ( "mov	%0,r2" ::"m"(usSaveStatusRegister));

/*-----------------------------------------------------------*/

#define portDISABLE_INTERRUPTS()	asm volatile ( "dint" :: );
#define portENABLE_INTERRUPTS()		asm volatile ( "eint" :: );

/*-----------------------------------------------------------*/

#define portSTACK_GROWTH			( -1 )

/*-----------------------------------------------------------*/
#define portTICKS_PER_MS			( ( unsigned portLONG ) 1000 / portTICK_RATE_HZ )

/*-----------------------------------------------------------*/

//extern void vPortYield( void ) __attribute__ ( ( naked ) );
void __attribute__ ( ( naked ) ) vPortYield( void ) ;
#define portYIELD()					vPortYield()

#endif /* PORTMACRO_H */
