/******************************************************************************
 ** The Clock Library
 **
 ** Look at Timer_A section of the user guide for understanding.
 **
 ** Toggle P2.CLKBIT  using software and the timer_A overflow ISR. 
 ** An Interrupt Service Routine will be triggered when TA overflows.
 ** Inside the ISR the CLKBIT is toggled. Toggle rate is exactly 0.25Hz.
 **
 ** ACLK = TACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1.048576MHz
 ** Use TASSEL_ACLK for a slower speed, and TASSEL_SMCLK for high speeds.
 ** Can be further slowed down by using ID_0 to ID_3.
 ** Look at timera.h for the complete list of macros.
 **
 ** copyright Resolution Systems Inc.
 ** by karan
 ******************************************************************************/

# ifndef __KMGCLOCK__
# define __KMGCLOCK__
/*============================================================================*/

# include  <io.h>
# include  <signal.h>
# include "../headers/kmglcd.h"

# ifndef CLKBIT
# define CLKBIT   BIT4
# endif

inline void initclock();
inline void startclock();
inline void stopclock();
inline void clkhigh();
inline void clklow();

/*****************************************************************************/

inline void initclock()
{ 
  P2DIR |= CLKBIT;
  clkhigh(); // set clk high initially
  stopclock();     // make sure clock is in stopped state initially
}

// Timer_A Interrupt Vector (TAIV) handler
interrupt (TIMERA1_VECTOR) Timer_A(void)
{
  switch( TAIV )
    {
    case  2:  break;                    // CCR1 not used
    case  4:  break;                    // CCR2 not used
    case 10:                            // overflow
      if ((P2OUT & CLKBIT) == 0x00)
	clkhigh();
      else
	clklow();
      break;
  }
}

inline void startclock()
{  
  TACTL = TASSEL_ACLK + TACLR + TAIE;       // ACLK, clr. TAR, interrupt
  //TACTL = TASSEL_SMCLK + TACLR + TAIE;       // SMCLK, clr. TAR, interrupt
  TACTL |= MC_2;     /* Timer A mode control 1 */  // Start Timer_a in continous
}

inline void stopclock()
{
  TACTL &= MC_0;     /* Timer A mode control: 0 - Stop */
}

inline void clkhigh()
{
  P2OUT |= CLKBIT;
  writedigit(2, '1');
}

inline void clklow()
{
  P2OUT &= ~CLKBIT;
  writedigit(2, '0');
}

/*============================================================================*/
# endif
