# include <io.h>
# include "i2cclock.h"
# include "../headers/kmgbuttons.h"

# ifndef CLKBIT
# define CLKBIT   BIT4
# endif
# define DATABIT  BIT3

# define sendbyte 0x4B

short sendposn = 0;
unsigned char sendmask = 0x80;

inline void pullDataLow();
inline void releaseDataHigh();

int main()
{

  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT

  initlcd();
  clearlcd();
  initclock();
  eint();                               // enable global int

  P2DIR |= DATABIT;                     // set port for OUTPUT
  releaseDataHigh();                    // set data line = 1
  P2IES |= CLKBIT;                      // select high-to-low edge for interrupt 
  P2IFG &= ~CLKBIT;                     // clr any pending int flags
  P2IE &= ~CLKBIT;                      // disable clk int
  if ((P2OUT & DATABIT) == DATABIT)
    writedigit(3, '1');
  else
    writedigit(3, '0'); 
  writeword("READY");

  while(1)
    {
      if (bttnhit(1))
	{
	  // carry out START cond.
	  sendposn = 0;
	  sendmask = 0x80;
	  pullDataLow();                // set data line = 0 to generate 1st data int on slave
	  startclock();                 // 1st data int enable clk ints on slave
	  P2IE |= CLKBIT;               // enable clk ints here
	  writeword("START");
	}
      if (bttnhit(2))               
	{
	  // send STOP
	  stopclock();                  // stop the clk timer
	  P2OUT |= CLKBIT;              // set clk line to 1
	  nop(); nop();                 // wait
	  releaseDataHigh();            // set data line to 1
	  writeword("STOP");
	  if ((P2OUT & CLKBIT) == CLKBIT)
	    writedigit(2, '1');
	  else
	    writedigit(2, '0');
	}
    }
  
  return 0;
}

interrupt (PORT2_VECTOR) Port2()
{
  if ((P2IFG & CLKBIT) == CLKBIT)
    {
      P2IE &= ~CLKBIT;                  // disable clk int
      
      if ((P2IES & CLKBIT) == CLKBIT)   // int trigerred coz of high-to-low transition
	P2IES &= ~CLKBIT;               // invert interrupt edge select
      else                              // int trigerred coz of low-to-high transition
	P2IES |= CLKBIT;

      if ((P2OUT & CLKBIT) == 0x00)        // clk is low
	{
	  if (sendposn != 8)               // send 8 bits
	    {
	      writedigit(4, (char)(sendposn+48));
	      if ((sendbyte & sendmask) == sendmask)
		releaseDataHigh();
	      else
		pullDataLow();
	      sendmask = sendmask >> 1;
	      sendposn++;      
	    }
	  if (sendposn == 8)
	    writeletter(7, sendbyte);
	}

      P2IFG &= ~CLKBIT;                   // clear int flag
      P2IE |= CLKBIT;                     // enable clk int
    }
}

inline void pullDataLow()
{ P2OUT &= ~DATABIT; writedigit(3, '0'); }

inline void releaseDataHigh()
{ P2OUT |= DATABIT; writedigit(3, '1'); }
