# include <io.h>
# include <signal.h>
# include "../headers/kmglcd.h"

# define CLKBIT   BIT4
# define DATABIT  BIT3

short rcvposn = 0;
unsigned char rcvbyte = 0x00;
short clk = 1;
short pendingclkint = 0;

void initSlave();

int main()
{

  WDTCTL = WDTPW + WDTHOLD;    // Stop WDT

  initlcd();
  clearlcd();
  eint();                      // enable global ints
  nop(); nop();
  initSlave();
  nop(); nop();

  while(1);                  // stay here and let the int handler take care of evrythin

  return 0;
}

interrupt (PORT2_VECTOR) Port2()
{

  if ((P2IFG & DATABIT) == DATABIT)      // if int flag for DATABIT is set
    {
      P2IE &= ~DATABIT;                  // disable int on data line
      nop(); nop();
      if ((P2IES & DATABIT) == DATABIT)  // int trigerred coz of high-to-low transition
	{
	  P2IES &= ~DATABIT;             // change, so that it detects low-to-high transition next time
	  P2IFG &= ~DATABIT;             // clr the int flag
	  P2IE |= CLKBIT;                // enable clk int

	  dint();
	  nop(); nop();

	  if ((P2IN & CLKBIT) == CLKBIT)
	    writedigit(2, '1');
	  else
	    writedigit(2, '0');
	  if ((P2IN & DATABIT) == DATABIT)
	    writedigit(3, '1');
	  else
	    writedigit(3, '0');
	  writeword("DLOW");
	}
      else                              // int trigerred coz of low-to-high transition on data line
	{
	  writeword("DHGH");
	  if (pendingclkint == 1) // if clk int has not been completed
	    {
	      if (clk == 1) // if clk is high
		{
		  initSlave();
		}
	      else
		writeword("ERR2");
	    }
	  else
	    writeword("ERR1");
	}
    }

  if ((P2IFG & CLKBIT) == CLKBIT)       // if int is on clk line   
    {
      P2IE &= ~CLKBIT;                  // disable clk int
      nop(); nop();
      pendingclkint = 1;

      if ((P2IES & CLKBIT) == CLKBIT)   // int trigerred coz of high-to-low transition
	{
	  P2IE &= ~DATABIT;             // disable data ints
	  nop(); nop();
	  P2IES &= ~CLKBIT;             // invert int select edge
	  clk = 0;
	  writedigit(2, '0');
	}
      else                              // int trigerred coz of low-to-high transition
	{
	  P2IES &= ~DATABIT;            // set int flag to detect low-to-high transition on the data
	  P2IFG &= ~DATABIT;            // clr data int flag AGAIN!!
	  nop(); nop();
	  P2IE |= DATABIT;              // enable data int
	  nop(); nop();
	  P2IES |= CLKBIT;              // invert int select edge
	  clk = 1;
	  writedigit(2, '1');
	  if (rcvposn != 8)                 // rcv 8 bits
	    {
	      writedigit(4, (char)(rcvposn+48));
	      rcvbyte = rcvbyte << 1;       // left shift rcvbyte
	      if ((P2IN & DATABIT) == DATABIT) // if data is high
		{
		  rcvbyte = rcvbyte | 0x01; 
		  writedigit(3, '1');
		}
	      else
		writedigit(3, '0');
	      rcvposn++;                   // increment bit counter
	    }
	  if (rcvposn == 8)                // ready for next byte
	    {
	      writeletter(7, rcvbyte);  
	      rcvposn = 0;
	      rcvbyte = 0x00;
	    }
	}
      
      P2IFG &= ~CLKBIT;                   // clr int flag to show its been handled
      pendingclkint = 0;
      P2IE |= CLKBIT;                     // enable clk int
    }
}

void initSlave()
{
  rcvposn = 0;
  rcvbyte = 0x00;

  clk = 1;
  pendingclkint = 0;

  P2DIR &= ~DATABIT;           // set registers as input
  P2DIR &= ~CLKBIT;
  
  P2IES |= DATABIT;            // select high-to-low edge for data interrupt
  P2IES |= CLKBIT;             // select high-to-low edge for clk interrupt
  P2IFG &= ~DATABIT;           // clear any int flags
  P2IFG &= ~CLKBIT;
  P2IE |= DATABIT;             // enable data int
  P2IE &= ~CLKBIT;             // disable clk int
  writeword("READY");

  if ((P2IN & CLKBIT) == CLKBIT)
    writedigit(2, '1');
  else
    writedigit(2, '0');
  if ((P2IN & DATABIT) == DATABIT)
    writedigit(3, '1');
  else
    writedigit(3, '0');
}
