#region GNU General Public License
//
// NAntContrib
// Copyright (C) 2001-2003 Gerry Shaw
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//

// Jason Reimer, Diversant Inc. (jason.reimer@diversant.net)
// William E. Caputo, ThoughtWorks Inc. (billc@thoughtworks.com)
#endregion

using System;
using System.Diagnostics;
using System.Text;

using NAnt.Core;
using NAnt.Core.Attributes;

namespace NAnt.Contrib.Tasks.Vault {

    /// <summary>
    /// Adds files / folders to a SourceGear Vault source repository.
    /// Author: Bart Read
    /// </summary>
    [TaskName("vaultadd")]
	public class AddTask : UpdateTask {

        bool    _commit;
        string  _localPath;

        /// <summary>
        /// Commit this action automatically.  Default is false.
        /// </summary>
        [TaskAttribute("commit")]
        public bool Commit {
            get { return _commit; }
            set { _commit = value; }
        }

        /// <summary>
        /// Local path of file / folder to add.
        /// </summary>
        [TaskAttribute("localpath")]
        public string LocalPath {
            get { return _localPath; }
            set { _localPath = value; }
        }

        protected override string CreateArguments() {
            StringBuilder arguments = new StringBuilder( "ADD" );

            arguments.Append( CreateCommonArguments() );

            arguments.Append( " -comment " );
            arguments.Append( "\"" + Comment + "\"" );

            if ( Commit ) {
                arguments.Append( " -commit" );
            }

            arguments.Append( " \"" + RepositoryPath + "\"" );
            arguments.Append( " \"" + LocalPath + "\"" );

            return arguments.ToString();
        }

	}

}