#region GNU General Public License
//
// NAntContrib
// Copyright (C) 2001-2003 Gerry Shaw
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//

// Jason Reimer, Diversant Inc. (jason.reimer@diversant.net)
// William E. Caputo, ThoughtWorks Inc. (billc@thoughtworks.com)
#endregion

using System;
using System.Diagnostics;
using System.Text;

using NAnt.Core;
using NAnt.Core.Attributes;

namespace NAnt.Contrib.Tasks.Vault {

    /// <summary>
    /// Checks out files from SourceGear Vault source repository.
    /// Author: Bart Read
    /// </summary>
    [TaskName("vaultcheckout")]
    public sealed class CheckoutTask : RetrievalTask {

        bool        _exclusive      = true;

        /// <summary>
        /// Will check out items exclusively.  Default is true.
        /// </summary>
        [TaskAttribute("exclusive")]
        public bool Exclusive {
            get { return _exclusive; }
            set { _exclusive = value; }
        }

        protected override string CreateArguments() {
            StringBuilder arguments = new StringBuilder( "CHECKOUT" );

            arguments.Append( CreateCommonArguments() );
            arguments.Append( CreateRetrievalArguments() );

            if ( Exclusive ) {
                arguments.Append( " -exclusive" );
            }

            arguments.Append( " \"" + RepositoryPath + "\"" );

            return arguments.ToString();
        }

    }

}
