#region GNU General Public License
//
// NAntContrib
// Copyright (C) 2001-2003 Gerry Shaw
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//

// Jason Reimer, Diversant Inc. (jason.reimer@diversant.net)
// William E. Caputo, ThoughtWorks Inc. (billc@thoughtworks.com)
#endregion

using System;
using System.Diagnostics;
using System.Text;

using NAnt.Core;
using NAnt.Core.Attributes;

namespace NAnt.Contrib.Tasks.Vault {

    /// <summary>
    /// Commit action for unchanged files.
    /// </summary>
    public enum Unchanged {
        Checkin,
        LeaveCheckedOut,
        UndoCheckout
    }

    /// <summary>
    /// Commits changes to SourceGear Vault repository.
    /// Author: Bart Read
    /// </summary>
    [TaskName("vaultcommit")]
    public sealed class CommitTask : UpdateTask {

        bool        _keepCheckedOut;
        Unchanged   _unchanged      = Unchanged.UndoCheckout;

        /// <summary>
        /// All files remain checked out upon commit.  Default is false.
        /// </summary>
        [TaskAttribute("keepcheckedout")]
        public bool KeepCheckedOut {
            get { return _keepCheckedOut; }
            set { _keepCheckedOut = value; }
        }

        /// <summary>
        /// Action to perform on an unchanged, checked-out file during
        /// commit.  Check the file in unmodified, leave the file checked
        /// out, or undo the checkout of the file.
        /// </summary>
        [TaskAttribute("unchanged")]
        public Unchanged Unchanged {
            get { return _unchanged; }
            set { _unchanged = value; }
        }

        protected override string CreateArguments() {
            StringBuilder arguments = new StringBuilder( "COMMIT" );

            arguments.Append( CreateCommonArguments() );

            arguments.Append( " -comment " );
            arguments.Append( "\"" + Comment + "\"" );

            if ( KeepCheckedOut ) {
                arguments.Append( " -keepcheckedout" );
            }

            arguments.Append( " -unchanged" );
            arguments.Append( Unchanged.ToString().ToLower() );

            return arguments.ToString();
        }

    }

}
